/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.BaseANR;
import de.gematik.test.erezept.fhir.values.LANR;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import java.util.List;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvPractitionerTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/kbv/1.0.2/bundle/";

    KbvPractitionerTest() {
    }

    @Test
    void testEncodingLANRPractitionerFromKbvBundle() {
        String kbvId = "5a3458b0-8364-4682-96e2-b262b2ab16eb";
        String fileName = "5a3458b0-8364-4682-96e2-b262b2ab16eb.xml";
        LANR expLanr = new LANR("754236701");
        String expName = "Ben Schulz";
        QualificationType expQualification = QualificationType.DOCTOR;
        String expAdditionalQualification = "Facharzt f\u00fcr Allgemeinmedizin";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPractitioner practitioner = kbvBundle.getPractitioner();
        Assertions.assertNotNull((Object)practitioner);
        Assertions.assertEquals((Object)expLanr, (Object)practitioner.getANR());
        Assertions.assertEquals((Object)BaseANR.ANRType.LANR, (Object)practitioner.getANRType());
        Assertions.assertEquals((Object)"Ben Schulz", (Object)practitioner.getFullName());
        Assertions.assertEquals((Object)expQualification, (Object)practitioner.getQualificationType());
        Assertions.assertEquals((int)1, (int)practitioner.getAdditionalQualifications().size());
        Assertions.assertEquals((Object)"Facharzt f\u00fcr Allgemeinmedizin", practitioner.getAdditionalQualifications().get(0));
        Assertions.assertNotNull((Object)practitioner.getDescription());
    }

    @Test
    void shouldThrowOnMissingFields() {
        String kbvId = "5a3458b0-8364-4682-96e2-b262b2ab16eb";
        String fileName = "5a3458b0-8364-4682-96e2-b262b2ab16eb.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPractitioner practitioner = kbvBundle.getPractitioner();
        practitioner.setQualification(List.of());
        practitioner.setIdentifier(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPractitioner)practitioner).getQualificationType());
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPractitioner)practitioner).getANR());
    }

    @Test
    void shouldGetSamePractitioner() {
        String kbvId = "5a3458b0-8364-4682-96e2-b262b2ab16eb";
        String fileName = "5a3458b0-8364-4682-96e2-b262b2ab16eb.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPractitioner practitioner = kbvBundle.getPractitioner();
        KbvPractitioner practitioner2 = KbvPractitioner.fromPractitioner((Practitioner)practitioner);
        Assertions.assertEquals((Object)practitioner, (Object)practitioner2);
    }

    @Test
    void shouldGetPractitionerFromResource() {
        Practitioner resource = new Practitioner();
        KbvPractitioner practitioner = KbvPractitioner.fromPractitioner((Resource)resource);
        Assertions.assertNotNull((Object)practitioner);
        Assertions.assertNotEquals((Object)resource, (Object)practitioner);
    }
}

