/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvEvdgaBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitionerRole;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvPractitionerRoleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_1 = "fhir/valid/kbv_evdga/1.1/";

    KbvPractitionerRoleTest() {
    }

    @Test
    void shouldThrowOnMissingTeamNumber01() {
        String bundleName = "EVDGA_Bundle_Krankenhaus";
        String fileName = "EVDGA_Bundle_Krankenhaus.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_Krankenhaus.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        KbvPractitionerRole practitionerRole = (KbvPractitionerRole)bundle.getPractitionerRole().orElseThrow();
        practitionerRole.setOrganization(null);
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPractitionerRole)practitionerRole).getTeamNumber());
    }

    @Test
    void shouldThrowOnMissingTeamNumber02() {
        String bundleName = "EVDGA_Bundle_Krankenhaus";
        String fileName = "EVDGA_Bundle_Krankenhaus.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_Krankenhaus.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        KbvPractitionerRole practitionerRole = (KbvPractitionerRole)bundle.getPractitionerRole().orElseThrow();
        practitionerRole.getOrganization().setIdentifier(null);
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPractitionerRole)practitionerRole).getTeamNumber());
    }
}

