/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import java.util.List;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class KbvPatientTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_0_2 = "fhir/valid/kbv/1.0.2/bundle/";
    private static final String BASE_PATH_1_1_0 = "fhir/valid/kbv/1.1.0/bundle/";

    KbvPatientTest() {
    }

    @Test
    void shouldDecodeWithoutExpectedType() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Resource patient = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Patient)).findFirst().orElseThrow();
        Assertions.assertEquals(KbvPatient.class, patient.getClass());
        Assertions.assertEquals((Object)patient, (Object)bundle.getPatient());
    }

    @ParameterizedTest
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/", "fhir/valid/kbv/1.1.0/bundle/"})
    void shouldGetKvnr(String basePath) {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        String content = ResourceLoader.readFileFromResource((String)(basePath + "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml"));
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPatient patient = bundle.getPatient();
        Assertions.assertEquals((Object)"K220635158", (Object)patient.getKvnr().getValue());
    }

    @Test
    void shouldThrowOnMissingIdentifiers() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        KbvErpBundle bundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvPatient patient = bundle.getPatient();
        patient.setIdentifier(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPatient)patient).getKvnr());
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvPatient)patient).getInsuranceKind());
    }
}

