/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.de.valueset.Country;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.BSNR;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvOrganizationTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/kbv/1.0.2/bundle/";

    KbvOrganizationTest() {
    }

    @Test
    void testEncodingOrganizationFromKbvBundle() {
        String kbvId = "5a3458b0-8364-4682-96e2-b262b2ab16eb";
        String fileName = "5a3458b0-8364-4682-96e2-b262b2ab16eb.xml";
        BSNR expBsnr = new BSNR("724444400");
        String expName = "Hausarztpraxis";
        String expPhone = "030321654987";
        String expMail = "hausarztpraxis@e-mail.de";
        String expCity = "Berlin";
        String expPostal = "10623";
        Country expCountry = Country.D;
        String expStreet = "Herbert-Lewin-Platz 2 Erdgeschoss";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvMedicalOrganization organization = kbvBundle.getMedicalOrganization();
        Assertions.assertNotNull((Object)organization);
        Assertions.assertEquals((Object)expBsnr, (Object)organization.getBsnr());
        Assertions.assertEquals((Object)"Hausarztpraxis", (Object)organization.getName());
        Assertions.assertEquals((Object)"030321654987", (Object)organization.getPhone());
        Assertions.assertEquals((Object)"hausarztpraxis@e-mail.de", (Object)organization.getMail());
        Assertions.assertEquals((Object)"Berlin", (Object)organization.getCity());
        Assertions.assertEquals((Object)"10623", (Object)organization.getPostalCode());
        Assertions.assertEquals((Object)expCountry, (Object)organization.getCountry());
        Assertions.assertEquals((Object)"Herbert-Lewin-Platz 2 Erdgeschoss", (Object)organization.getStreet());
        Assertions.assertNotNull((Object)organization.getDescription());
    }
}

