/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.date.DateConverter;
import de.gematik.test.erezept.fhir.r4.kbv.KbvEvdgaBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvHealthAppRequest;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.AccidentCauseType;
import java.util.UUID;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvHealthAppRequestTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_0_0 = "fhir/valid/kbv_evdga/1.1/";

    KbvHealthAppRequestTest() {
    }

    @Test
    void shouldGetHealthAppRequestFromBundle() {
        String expectedID = "EVDGA_Bundle";
        String fileName = "EVDGA_Bundle.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        KbvHealthAppRequest appRequest = bundle.getHealthAppRequest();
        Assertions.assertNotNull((Object)appRequest);
        Assertions.assertEquals((Object)"Vantis KHK und Herzinfarkt 001", (Object)appRequest.getName());
        Assertions.assertEquals((Object)"19205615", (Object)appRequest.getPzn().getValue());
        Assertions.assertFalse((boolean)appRequest.getDescription().isEmpty());
        Assertions.assertFalse((boolean)appRequest.relatesToSocialCompensationLaw());
        Assertions.assertFalse((boolean)appRequest.hasAccidentExtension());
    }

    @Test
    void shouldGetHealthAppRequestForWorkAccident() {
        String expectedID = "EVDGA_Bundle_BG_Arbeitsunfall_3";
        String fileName = "EVDGA_Bundle_BG_Arbeitsunfall_3.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_BG_Arbeitsunfall_3.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        KbvHealthAppRequest appRequest = bundle.getHealthAppRequest();
        Assertions.assertNotNull((Object)appRequest);
        Assertions.assertEquals((Object)"companion patella", (Object)appRequest.getName());
        Assertions.assertEquals((Object)"17850263", (Object)appRequest.getPzn().getValue());
        Assertions.assertTrue((boolean)appRequest.getAccidentCause().isPresent());
        Assertions.assertEquals((Object)AccidentCauseType.ACCIDENT_AT_WORK, appRequest.getAccidentCause().get());
        Assertions.assertTrue((boolean)appRequest.getAccidentWorkplace().isPresent());
        Assertions.assertEquals((Object)"Dummy-Betrieb", appRequest.getAccidentWorkplace().get());
        Assertions.assertTrue((boolean)appRequest.getAccidentDate().isPresent());
        Assertions.assertEquals((Object)DateConverter.getInstance().dateFromIso8601("2023-03-26"), appRequest.getAccidentDate().get());
    }

    @Test
    void shouldCopyFromDeviceRequest() {
        String originalId = UUID.randomUUID().toString();
        DeviceRequest original = new DeviceRequest();
        original.setId(originalId);
        KbvHealthAppRequest healthAppRequest = KbvHealthAppRequest.fromDeviceRequest((Resource)original);
        Assertions.assertEquals((Object)originalId, (Object)healthAppRequest.getId());
        Assertions.assertNotEquals((Object)original, (Object)healthAppRequest);
    }

    @Test
    void shouldNotCopyFromHealtAppRequest() {
        String originalId = UUID.randomUUID().toString();
        KbvHealthAppRequest original = new KbvHealthAppRequest();
        original.setId(originalId);
        KbvHealthAppRequest healthAppRequest = KbvHealthAppRequest.fromDeviceRequest((Resource)original);
        Assertions.assertEquals((Object)originalId, (Object)healthAppRequest.getId());
        Assertions.assertEquals((Object)original, (Object)healthAppRequest);
    }
}

