/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvEvdgaBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvHealthAppRequest;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitionerRole;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvEvdgaBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_1 = "fhir/valid/kbv_evdga/1.1/";

    KbvEvdgaBundleTest() {
    }

    @Test
    void shouldGetHealthAppRequestFromBundle() {
        String expectedID = "EVDGA_Bundle";
        String fileName = "EVDGA_Bundle.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_162, (Object)bundle.getFlowType());
        Assertions.assertEquals((Object)"162.100.000.000.027.75", (Object)bundle.getPrescriptionId().getValue());
        KbvHealthAppRequest appRequest = bundle.getHealthAppRequest();
        Assertions.assertNotNull((Object)appRequest);
        KbvPatient patient = bundle.getPatient();
        Assertions.assertNotNull((Object)patient);
        Assertions.assertEquals((Object)"X234567890", (Object)patient.getKvnr().getValue());
        KbvPractitioner practitioner = bundle.getPractitioner();
        Assertions.assertNotNull((Object)practitioner);
        Assertions.assertEquals((Object)"838382202", (Object)practitioner.getANR().getValue());
        Assertions.assertTrue((boolean)bundle.getPractitionerRole().isEmpty());
        KbvMedicalOrganization medicalOrg = bundle.getMedicalOrganization();
        Assertions.assertNotNull((Object)medicalOrg);
        Assertions.assertEquals((Object)"031234567", (Object)medicalOrg.getBsnr().getValue());
        KbvCoverage coverage = bundle.getCoverage();
        Assertions.assertNotNull((Object)coverage);
        Assertions.assertEquals((Object)"104212059", (Object)coverage.getIknr().getValue());
        String description = (String)Assertions.assertDoesNotThrow(() -> ((KbvEvdgaBundle)bundle).getDescription());
        Assertions.assertFalse((boolean)description.isEmpty());
    }

    @Test
    void shouldReadAllPractitioners() {
        String expectedID = "EVDGA_Bundle_BG_Arbeitsunfall_3";
        String fileName = "EVDGA_Bundle_BG_Arbeitsunfall_3.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_BG_Arbeitsunfall_3.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        List practitioners = bundle.getAllPractitioners();
        List<String> lanrs = List.of("838382210", "838382202");
        Assertions.assertEquals((int)lanrs.size(), (int)practitioners.size());
        practitioners.forEach(practitioner -> Assertions.assertTrue((boolean)lanrs.contains(practitioner.getANR().getValue())));
    }

    @Test
    void shouldReadRole() {
        String expectedID = "EVDGA_Bundle_Krankenhaus";
        String fileName = "EVDGA_Bundle_Krankenhaus.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_Krankenhaus.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        Optional practitionerRole = bundle.getPractitionerRole();
        Assertions.assertTrue((boolean)practitionerRole.isPresent());
    }

    @Test
    void shouldThrowOnMissingDeviceRequest() {
        String expectedID = "EVDGA_Bundle_BG_Arbeitsunfall_3";
        String fileName = "EVDGA_Bundle_BG_Arbeitsunfall_3.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_BG_Arbeitsunfall_3.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        bundle.getEntry().removeIf(entry -> entry.getResource().getResourceType().equals((Object)ResourceType.DeviceRequest));
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvEvdgaBundle)bundle).getHealthAppRequest());
    }

    @Test
    void shouldCastPractitionerRole() {
        String expectedID = "EVDGA_Bundle_BG_Arbeitsunfall_3";
        String fileName = "EVDGA_Bundle_BG_Arbeitsunfall_3.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv_evdga/1.1/EVDGA_Bundle_BG_Arbeitsunfall_3.xml");
        KbvEvdgaBundle bundle = (KbvEvdgaBundle)parser.decode(KbvEvdgaBundle.class, content);
        bundle.addEntry(new Bundle.BundleEntryComponent().setResource((Resource)new PractitionerRole()));
        Optional practitionerRoleOptional = (Optional)Assertions.assertDoesNotThrow(() -> ((KbvEvdgaBundle)bundle).getPractitionerRole());
        Assertions.assertTrue((boolean)practitionerRoleOptional.isPresent());
        Assertions.assertEquals(KbvPractitionerRole.class, ((KbvPractitionerRole)practitionerRoleOptional.get()).getClass());
    }
}

