/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.FhirVersionException;
import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationCompoundingFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KbvErpMedicationTest
extends ErpFhirParsingTest {
    KbvErpMedicationTest() {
    }

    @Test
    void shouldDetectVersionCorrectly() {
        List.of(KbvItaErpVersion.V1_0_2, KbvItaErpVersion.V1_1_0).forEach(version -> {
            KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().withVersion(version).fake();
            Assertions.assertEquals((Object)version, (Object)medication.getVersion());
        });
    }

    @Test
    void shouldThrowIfMedicationDoesNotContainAProfile() {
        KbvErpMedication medication = new KbvErpMedication();
        Assertions.assertThrows(FhirVersionException.class, () -> ((KbvErpMedication)medication).getVersion());
    }

    @Test
    void shouldProvideDefaultVersionIfMissing() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        medication.getMeta().getProfile().forEach(profile -> {
            String withoutVersion = profile.asStringValue().split("\\|")[0];
            profile.setValueAsString(withoutVersion);
        });
        Assertions.assertEquals((Object)KbvItaErpVersion.getDefaultVersion(), (Object)medication.getVersion());
    }

    @Test
    void getPznOptionalShouldWorkForMedicationCompound() {
        PZN pzn = PZN.random();
        KbvErpMedication medComp = KbvErpMedicationCompoundingFaker.builder().withMedicationIngredient(pzn, "", "").fake();
        Assertions.assertTrue((boolean)medComp.getPznOptional().isPresent());
        Assertions.assertEquals((Object)pzn.getValue(), (Object)((PZN)medComp.getPznOptional().get()).getValue());
    }

    @Test
    void getPznOptionalShouldWorkForMedicationPZN() {
        String pzn = (String)PZN.random().getValue();
        KbvErpMedication medComp = KbvErpMedicationPZNFaker.builder().withPznMedication(pzn, "Useless Medicine").fake();
        Assertions.assertTrue((boolean)medComp.getPznOptional().isPresent());
        Assertions.assertEquals((Object)pzn, (Object)((PZN)medComp.getPznOptional().get()).getValue());
    }

    @Test
    void shouldGetFreeText() {
        KbvErpMedication medication = KbvErpMedicationPZNFaker.builder().fake();
        Assertions.assertDoesNotThrow(() -> ((KbvErpMedication)medication).getFreeText());
    }

    @Test
    void shouldThrowOnMissingCategory() {
        List categories = Collections.emptyList();
        KbvErpMedication medication = (KbvErpMedication)Mockito.mock(KbvErpMedication.class);
        Mockito.when((Object)medication.getCatagory()).thenReturn(categories);
        Mockito.when((Object)medication.getCategoryFirstRep()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvErpMedication)medication).getCategoryFirstRep());
    }

    @Test
    void shouldThrowOnMissingPzn() {
        List listOfPzn = Collections.emptyList();
        KbvErpMedication medication = (KbvErpMedication)Mockito.mock(KbvErpMedication.class);
        Mockito.when((Object)medication.getPzn()).thenReturn(listOfPzn);
        Mockito.when((Object)medication.getPznFirstRep()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvErpMedication)medication).getPznFirstRep());
    }
}

