/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.date.DateCalculator;
import de.gematik.test.erezept.fhir.date.DateConverter;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedicationRequest;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.AccidentCauseType;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Period;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class KbvErpMedicationRequestTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/kbv/1.0.2/medicationrequest/";

    KbvErpMedicationRequestTest() {
    }

    @Test
    void encodingSingleValidMedicationRequest() {
        String expectedID = "0587787f-3f1b-4578-a412-ce5bae8215b9";
        String fileName = "0587787f-3f1b-4578-a412-ce5bae8215b9.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/0587787f-3f1b-4578-a412-ce5bae8215b9.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertNotNull((Object)medicationRequest);
        Assertions.assertEquals((Object)"0587787f-3f1b-4578-a412-ce5bae8215b9", (Object)medicationRequest.getLogicalId());
        Assertions.assertTrue((boolean)medicationRequest.getCoPaymentStatus().isPresent());
        Assertions.assertEquals((Object)StatusCoPayment.STATUS_0, medicationRequest.getCoPaymentStatus().get());
        Assertions.assertTrue((boolean)medicationRequest.getNoteText().isPresent());
        String expectedNote = "Patient erneut auf Anwendung der Schmelztabletten hinweisen";
        Assertions.assertEquals((Object)"Patient erneut auf Anwendung der Schmelztabletten hinweisen", (Object)medicationRequest.getNoteTextOrEmpty());
        Assertions.assertNotNull((Object)medicationRequest.getDescription());
        Assertions.assertFalse((boolean)medicationRequest.allowSubstitution());
        Assertions.assertTrue((boolean)medicationRequest.getDescription().contains("ohne aut-idem"));
    }

    @ParameterizedTest(name="[{index}] -> Check Accident in MedicationRequest from {0}")
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml", "fhir/valid/kbv/1.1.0/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml"})
    void shouldFindAccidents(String file) {
        String content = ResourceLoader.readFileFromResource((String)file);
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertTrue((boolean)medicationRequest.hasAccidentExtension());
        Assertions.assertTrue((boolean)medicationRequest.getAccident().isPresent());
        Assertions.assertEquals((Object)AccidentCauseType.ACCIDENT, medicationRequest.getAccidentCause().orElseThrow());
        Assertions.assertFalse((boolean)medicationRequest.getAccidentWorkplace().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getAccidentDate().isPresent());
    }

    @ParameterizedTest(name="[{index}] -> Check Accident at work in MedicationRequest from {0}")
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/5f66314e-459a-41e9-a3d7-65c935a8be2c.xml", "fhir/valid/kbv/1.1.0/bundle/5f66314e-459a-41e9-a3d7-65c935a8be2c.xml"})
    void shouldFindAccidentsAtWork(String file) {
        String content = ResourceLoader.readFileFromResource((String)file);
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertTrue((boolean)medicationRequest.hasAccidentExtension());
        Assertions.assertTrue((boolean)medicationRequest.getAccident().isPresent());
        Assertions.assertEquals((Object)AccidentCauseType.ACCIDENT_AT_WORK, medicationRequest.getAccidentCause().orElseThrow());
        Assertions.assertEquals((Object)"Arbeitsplatz", medicationRequest.getAccidentWorkplace().orElseThrow());
        Assertions.assertTrue((boolean)medicationRequest.getAccidentDate().isPresent());
    }

    @ParameterizedTest(name="[{index}] -> Check occupational disease in MedicationRequest from {0}")
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/218b581d-ccbe-480e-b8d7-f5f9b925e8c4.xml", "fhir/valid/kbv/1.1.0/bundle/218b581d-ccbe-480e-b8d7-f5f9b925e8c4.xml"})
    void shouldFindAccidentsOccupationalDisease(String file) {
        String content = ResourceLoader.readFileFromResource((String)file);
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertTrue((boolean)medicationRequest.hasAccidentExtension());
        Assertions.assertTrue((boolean)medicationRequest.getAccident().isPresent());
        Assertions.assertEquals((Object)AccidentCauseType.OCCUPATIONAL_DISEASE, medicationRequest.getAccidentCause().orElseThrow());
        Assertions.assertFalse((boolean)medicationRequest.getAccidentWorkplace().isPresent());
        Assertions.assertFalse((boolean)medicationRequest.getAccidentDate().isPresent());
    }

    @Test
    void encodeMedicationRequestWithoutNote() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertFalse((boolean)medicationRequest.getNoteText().isPresent());
        Assertions.assertFalse((boolean)medicationRequest.isMultiple());
        Assertions.assertEquals((Object)"", (Object)medicationRequest.getNoteTextOrEmpty());
        Assertions.assertEquals((Object)"N/A", (Object)medicationRequest.getNoteTextOr("N/A"));
    }

    @Test
    void encodeMedicationRequestWithMvo() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertTrue((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getMvoStart().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isPresent());
        Assertions.assertNotNull((Object)medicationRequest.getDescription());
        Assertions.assertTrue((boolean)medicationRequest.getDescription().contains("mit aut-idem"));
    }

    @Test
    void shouldDefaultSubstitutionToFalse() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().fake();
        KbvErpMedicationRequest medicationRequest = bundle.getMedicationRequest();
        medicationRequest.setSubstitution(null);
        Assertions.assertFalse((boolean)bundle.getMedicationRequest().isSubstitutionAllowed());
    }

    @Test
    void encodeMedicationRequCheckForNumAndDenom() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertTrue((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getNumerator().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getDemoninator().isPresent());
        Assertions.assertEquals((int)4, (Integer)((Integer)medicationRequest.getNumerator().orElseThrow()));
        Assertions.assertEquals((int)4, (Integer)((Integer)medicationRequest.getDemoninator().orElseThrow()));
    }

    @Test
    void shouldManuallyChangeMvoDates() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertTrue((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getMvoStart().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isPresent());
        Date originalStart = (Date)medicationRequest.getMvoStart().orElseThrow();
        Date originalEnd = (Date)medicationRequest.getMvoEnd().orElseThrow();
        ((Period)medicationRequest.getMvoPeriod().orElseThrow()).setStart(new Date());
        ((Period)medicationRequest.getMvoPeriod().orElseThrow()).setEnd(new Date());
        Date newStart = (Date)medicationRequest.getMvoStart().orElseThrow();
        Date newEnd = (Date)medicationRequest.getMvoEnd().orElseThrow();
        Assertions.assertNotEquals((Object)originalStart, (Object)newStart);
        Assertions.assertNotEquals((Object)originalEnd, (Object)newEnd);
        medicationRequest.updateMvoDates();
        Assertions.assertNotEquals((Object)newStart, medicationRequest.getMvoStart().orElseThrow());
        Assertions.assertNotEquals((Object)newEnd, medicationRequest.getMvoEnd().orElseThrow());
    }

    @Test
    void shouldUpdateMvoDates() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d3a.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertTrue((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getMvoStart().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isPresent());
        Date oStart = (Date)medicationRequest.getMvoStart().orElseThrow();
        Date oEnd = (Date)medicationRequest.getMvoEnd().orElseThrow();
        medicationRequest.updateMvoDates();
        Date nStart = (Date)medicationRequest.getMvoStart().orElseThrow();
        Date nEnd = (Date)medicationRequest.getMvoEnd().orElseThrow();
        Assertions.assertEquals((int)1, (int)this.diff(1, oStart, oEnd));
        Assertions.assertEquals((int)1, (int)this.diff(2, oStart, oEnd));
        Assertions.assertEquals((int)1, (int)this.diff(5, oStart, oEnd));
        DateConverter converter = DateConverter.getInstance();
        java.time.Period oDiff = java.time.Period.between(converter.dateToLocalDate(oStart), converter.dateToLocalDate(oEnd));
        java.time.Period nDiff = java.time.Period.between(converter.dateToLocalDate(nStart), converter.dateToLocalDate(nEnd));
        Assertions.assertEquals((Object)oDiff, (Object)nDiff);
    }

    @Test
    void shouldUpdateWithoutEnd() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d5e";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d5e.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d5e.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertTrue((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getMvoStart().isPresent());
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isEmpty());
        medicationRequest.updateMvoDates();
        DateCalculator dc = new DateCalculator();
        Assertions.assertTrue((boolean)dc.isToday((Date)medicationRequest.getMvoStart().orElseThrow()));
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isEmpty());
    }

    @Test
    void shouldGetEmptyOptionalOnNonMvo() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertFalse((boolean)medicationRequest.getNoteText().isPresent());
        Assertions.assertFalse((boolean)medicationRequest.isMultiple());
        Assertions.assertTrue((boolean)medicationRequest.getMvoPeriod().isEmpty());
        Assertions.assertTrue((boolean)medicationRequest.getMvoStart().isEmpty());
        Assertions.assertTrue((boolean)medicationRequest.getMvoEnd().isEmpty());
    }

    @Test
    void shouldGetKbvErpMedicationRequestFromResource() {
        MedicationRequest resource = new MedicationRequest();
        KbvErpMedicationRequest kbvMedReq = KbvErpMedicationRequest.fromMedicationRequest((MedicationRequest)resource);
        Assertions.assertNotNull((Object)kbvMedReq);
        Assertions.assertEquals(KbvErpMedicationRequest.class, kbvMedReq.getClass());
    }

    @Test
    void getEmptyAtNoMultiple() {
        String expectedID = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f";
        String fileName = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/medicationrequest/43c2b7ae-ad11-4387-910a-e6b7a3c38d4f.xml");
        KbvErpMedicationRequest medicationRequest = (KbvErpMedicationRequest)parser.decode(KbvErpMedicationRequest.class, content);
        Assertions.assertFalse((boolean)medicationRequest.getNoteText().isPresent());
        Assertions.assertFalse((boolean)medicationRequest.isMultiple());
        Assertions.assertEquals(Optional.empty(), (Object)medicationRequest.getNumerator());
        Assertions.assertEquals(Optional.empty(), (Object)medicationRequest.getDemoninator());
        Assertions.assertEquals(Optional.empty(), (Object)medicationRequest.getMvoEnd());
        Assertions.assertEquals(Optional.empty(), (Object)medicationRequest.getMvoStart());
    }

    private int diff(int type, Date start, Date end) {
        Calendar cStart = Calendar.getInstance();
        cStart.setTime(start);
        Calendar cEnd = Calendar.getInstance();
        cEnd.setTime(end);
        return cEnd.get(type) - cStart.get(type);
    }
}

