/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.coding.version.ProfileVersion;
import de.gematik.bbriccs.fhir.de.value.IKNR;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.value.PZN;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.KbvItaErpStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedicationRequest;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import de.gematik.test.erezept.fhir.valuesets.MedicationType;
import de.gematik.test.erezept.fhir.valuesets.PersonGroup;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import de.gematik.test.erezept.fhir.valuesets.StandardSize;
import de.gematik.test.erezept.fhir.valuesets.VersichertenStatus;
import de.gematik.test.erezept.fhir.valuesets.Wop;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class KbvErpBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_0_2 = "fhir/valid/kbv/1.0.2/bundle/";
    private static final String BASE_PATH_1_1_0 = "fhir/valid/kbv/1.1.0/bundle/";

    KbvErpBundleTest() {
    }

    @Test
    void testEncodingCodingSingleValidKbvBundle() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        PrescriptionId expectedPrescriptionId = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, "160.100.000.000.037.28");
        String expectedMedicationRequestId = "43c2b7ae-ad11-4387-910a-e6b7a3c38d4f";
        InsuranceTypeDe expectedInsuranceType = InsuranceTypeDe.GKV;
        String expectedKvnr = "K220635158";
        String expectedGivenName = "Ludger";
        String expectedLastName = "K\u00f6nigsstein";
        String expectedFamilyName = "K\u00f6nigsstein";
        Date expectedBirthDate = new GregorianCalendar(1935, 5, 22).getTime();
        String expectedCity = "Esens";
        String expectedPostal = "26427";
        String expectedStreet = "Blumenweg";
        String expectedCoverageIknr = "109719018";
        String expectedCoverageName = "AOK Nordost";
        InsuranceTypeDe expectedCoverageKind = InsuranceTypeDe.GKV;
        Wop expectedCoverageWop = Wop.NIEDERSACHSEN;
        VersichertenStatus expectedCoverageState = VersichertenStatus.PENSIONER;
        PersonGroup expectedCoveragePersonGroup = PersonGroup.NOT_SET;
        MedicationCategory expectedMedicationCategory = MedicationCategory.C_00;
        boolean expectedMedicationAmount = false;
        boolean expectedQuantity = true;
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        EncodingType originalEncoding = EncodingType.fromString((String)"1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        EncodingType flippedEncoding = originalEncoding.flipEncoding();
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)"1f339db0-9e55-4946-9dfa-f1b30953be9b", (Object)kbvBundle.getLogicalId());
        Assertions.assertEquals((Object)"1f339db0-9e55-4946-9dfa-f1b30953be9b", (Object)kbvBundle.asReference().getReference());
        Assertions.assertNotNull((Object)kbvBundle.getDescription());
        Assertions.assertEquals((Object)KbvItaErpStructDef.BUNDLE.getVersionedUrl((ProfileVersion)KbvItaErpVersion.V1_0_2), (Object)kbvBundle.getFullMetaProfile());
        Assertions.assertEquals((Object)KbvItaErpStructDef.BUNDLE.getCanonicalUrl(), (Object)kbvBundle.getMetaProfile());
        Assertions.assertEquals((Object)expectedPrescriptionId, (Object)kbvBundle.getPrescriptionId());
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_160, (Object)kbvBundle.getFlowType());
        Assertions.assertEquals((Object)"43c2b7ae-ad11-4387-910a-e6b7a3c38d4f", (Object)kbvBundle.getMedicationRequest().getLogicalId());
        Assertions.assertFalse((boolean)kbvBundle.getMedicationRequest().hasEmergencyServiceFee());
        Assertions.assertEquals((Object)expectedInsuranceType, (Object)kbvBundle.getPatient().getInsuranceKind());
        Assertions.assertEquals((Object)"K220635158", (Object)kbvBundle.getPatient().getKvnr().getValue());
        Assertions.assertEquals((Object)"Ludger", (Object)kbvBundle.getPatient().getGivenName());
        Assertions.assertEquals((Object)"K\u00f6nigsstein", (Object)kbvBundle.getPatient().getFamilyName());
        Assertions.assertEquals((Object)"K\u00f6nigsstein", (Object)kbvBundle.getPatient().getFamilyName());
        Assertions.assertEquals((Object)expectedBirthDate, (Object)kbvBundle.getPatient().getBirthDate());
        Assertions.assertEquals((Object)"Esens", (Object)kbvBundle.getPatient().getAddressCity());
        Assertions.assertEquals((Object)"26427", (Object)kbvBundle.getPatient().getAddressPostalCode());
        Assertions.assertEquals((Object)"Blumenweg", (Object)kbvBundle.getPatient().getAddressStreet());
        Assertions.assertEquals((Object)"109719018", (Object)kbvBundle.getCoverage().getIknr().getValue());
        Assertions.assertEquals((Object)"AOK Nordost", (Object)kbvBundle.getCoverage().getName());
        Assertions.assertEquals((Object)expectedCoverageKind, (Object)kbvBundle.getCoverage().getInsuranceKind());
        Assertions.assertTrue((boolean)kbvBundle.getCoverage().hasInsuranceKind());
        Assertions.assertFalse((boolean)kbvBundle.getCoverage().hasPayorType());
        Assertions.assertEquals((Object)expectedCoverageWop, kbvBundle.getCoverage().getWop().orElseThrow());
        Assertions.assertEquals((Object)expectedCoverageState, (Object)kbvBundle.getCoverage().getInsurantState());
        Assertions.assertEquals((Object)expectedCoveragePersonGroup, (Object)kbvBundle.getCoverage().getPersonGroup());
        Assertions.assertEquals((Object)expectedMedicationCategory, (Object)kbvBundle.getMedication().getCategoryFirstRep());
        Assertions.assertEquals((int)0, (int)kbvBundle.getMedication().getPackagingSizeOrEmpty());
        Assertions.assertEquals((int)1, (int)kbvBundle.getMedicationRequest().getDispenseQuantity());
        Assertions.assertFalse((boolean)kbvBundle.getMedicationRequest().isMultiple());
        Assertions.assertFalse((boolean)kbvBundle.getAssignerOrganization().isPresent());
        KbvErpMedication medication = kbvBundle.getMedication();
        Assertions.assertEquals((Object)StandardSize.N1, (Object)medication.getStandardSize());
        Assertions.assertNotNull((Object)medication.getDescription());
        Assertions.assertEquals((Object)KbvItaErpVersion.V1_0_2, (Object)medication.getVersion());
        Assertions.assertTrue((boolean)medication.getPackagingSize().isEmpty());
        Assertions.assertTrue((boolean)medication.getPackagingUnit().isEmpty());
        Composition composition = kbvBundle.getComposition();
        String compProfile = ((CanonicalType)composition.getMeta().getProfile().get(0)).asStringValue();
        String expectedProfile = KbvItaErpStructDef.COMPOSITION.getVersionedUrl((ProfileVersion)KbvItaErpVersion.V1_0_2);
        Assertions.assertEquals((Object)expectedProfile, (Object)compProfile);
        String flippedContent = parser.encode((IBaseResource)kbvBundle, flippedEncoding);
        KbvErpBundle flippedKbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, flippedContent);
        Assertions.assertEquals((Object)kbvBundle.getLogicalId(), (Object)flippedKbvBundle.getLogicalId());
    }

    @ParameterizedTest(name="Find 'Emergency Fee' in MedicationRequest")
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/", "fhir/valid/kbv/1.1.0/bundle/"})
    void shouldFindEmergencyFee(String base) {
        String expectedId = "690a7f01-058e-492a-b1dc-d6d8c8a30a59";
        String fileName = "690a7f01-058e-492a-b1dc-d6d8c8a30a59.xml";
        String content = ResourceLoader.readFileFromResource((String)(base + "690a7f01-058e-492a-b1dc-d6d8c8a30a59.xml"));
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertTrue((boolean)medicationRequest.hasEmergencyServiceFee());
    }

    @ParameterizedTest(name="Find 'BVG' in MedicationRequest")
    @ValueSource(strings={"fhir/valid/kbv/1.0.2/bundle/", "fhir/valid/kbv/1.1.0/bundle/"})
    void shouldFindBvg(String base) {
        String expectedId = "aea2f4c5-675a-4d76-ab9b-7994c80b64ec";
        String fileName = "aea2f4c5-675a-4d76-ab9b-7994c80b64ec.xml";
        String content = ResourceLoader.readFileFromResource((String)(base + "aea2f4c5-675a-4d76-ab9b-7994c80b64ec.xml"));
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertTrue((boolean)medicationRequest.isBvg());
    }

    @Test
    void shouldValidateKbvBundle() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertFalse((boolean)kbvBundle.toString().isEmpty());
    }

    @Test
    void shouldGetMedicalOrganization() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvBundle).getMedicalOrganization());
        Assertions.assertNotNull((Object)kbvBundle.getMedicalOrganization());
    }

    @Test
    void encodeSinglePkvKbvBundle() {
        String expectedID = "328ad940-3fff-11ed-b878-0242ac120002";
        String fileName = "328ad940-3fff-11ed-b878-0242ac120002.xml";
        IKNR expectedIknr = IKNR.asSidIknr((String)"123456789");
        String expectedName = "Allianz Private Krankenversicherung";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/328ad940-3fff-11ed-b878-0242ac120002.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertTrue((boolean)kbvBundle.getAssignerOrganization().isEmpty());
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_160, (Object)kbvBundle.getFlowType());
        KbvCoverage coverage = kbvBundle.getCoverage();
        Assertions.assertEquals((Object)expectedIknr, (Object)coverage.getIknr());
        Assertions.assertEquals((Object)"Allianz Private Krankenversicherung", (Object)coverage.getName());
        Assertions.assertDoesNotThrow(() -> kbvBundle.getPatient().getKvnr());
    }

    @Test
    void shouldChangePrescriptionId() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        PrescriptionId expectedPrescriptionId = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, "160.100.000.000.037.28");
        PrescriptionId randomPrescriptionId = PrescriptionId.random((PrescriptionFlowType)PrescriptionFlowType.FLOW_TYPE_160);
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)expectedPrescriptionId, (Object)kbvBundle.getPrescriptionId());
        kbvBundle.setPrescriptionId(randomPrescriptionId);
        Assertions.assertEquals((Object)randomPrescriptionId, (Object)kbvBundle.getPrescriptionId());
    }

    @Test
    void shouldThrowOnInvalidPrescriptionIdSystem() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        PrescriptionId mockPrescriptionId = (PrescriptionId)Mockito.mock(PrescriptionId.class);
        Mockito.when((Object)mockPrescriptionId.getSystemUrl()).thenReturn((Object)"hello_world");
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        kbvBundle.setPrescriptionId(mockPrescriptionId);
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvErpBundle)kbvBundle).getPrescriptionId());
    }

    @Test
    void testEncodingCodingSingleValidKbvBundleWitzPzn() {
        String expectedID = "5a3458b0-8364-4682-96e2-b262b2ab16eb";
        String fileName = "5a3458b0-8364-4682-96e2-b262b2ab16eb.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/5a3458b0-8364-4682-96e2-b262b2ab16eb.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        String expectedPzn = "03507952";
        String expectedName = "Novaminsulfon 500 mg Lichtenstein 100 ml Tropf. N3";
        String expectedDosage = "bis zu 4mal t\u00e4glich je 20-40 Tropfen";
        String expectedNumerator = "100 ml";
        Assertions.assertTrue((boolean)kbvBundle.getMedication().getPznOptional().isPresent());
        Assertions.assertEquals((Object)"03507952", (Object)kbvBundle.getMedication().getPznFirstRep());
        Assertions.assertEquals((Object)"Novaminsulfon 500 mg Lichtenstein 100 ml Tropf. N3", (Object)kbvBundle.getMedication().getMedicationName());
        Assertions.assertEquals((Object)"bis zu 4mal t\u00e4glich je 20-40 Tropfen", (Object)kbvBundle.getMedicationRequest().getDosageInstructionAsText());
        Assertions.assertTrue((boolean)kbvBundle.getMedicationRequest().isSubstitutionAllowed());
        Assertions.assertFalse((boolean)kbvBundle.getMedication().getMedicationType().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getMedication().getIngredientText().isPresent());
        Assertions.assertFalse((boolean)kbvBundle.getMedication().getIngredientStrengthString().isPresent());
        Assertions.assertTrue((boolean)kbvBundle.getMedication().getAmountNumeratorString().isPresent());
        Assertions.assertEquals((Object)"100 ml", kbvBundle.getMedication().getAmountNumeratorString().orElseThrow());
    }

    @Test
    void testEncodingSingleKbvBundleIngredient() {
        String expectedID = "9c85a2a5-92ee-4a57-83cb-ba90a0df2a21";
        String fileName = "9c85a2a5-92ee-4a57-83cb-ba90a0df2a21.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/9c85a2a5-92ee-4a57-83cb-ba90a0df2a21.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)MedicationType.INGREDIENT, kbvBundle.getMedication().getMedicationType().orElseThrow());
        Assertions.assertEquals((Object)"Ramipril", kbvBundle.getMedication().getIngredientText().orElseThrow());
        Assertions.assertEquals((Object)"100 St\u00fcck", kbvBundle.getMedication().getAmountNumeratorString().orElseThrow());
        Assertions.assertEquals((Object)"5 mg", kbvBundle.getMedication().getIngredientStrengthString().orElseThrow());
    }

    @Test
    void testEncodingSingleKbvBundleCompounding() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)MedicationType.COMPOUNDING, kbvBundle.getMedication().getMedicationType().orElseThrow());
        Assertions.assertEquals((Object)"500 ml", kbvBundle.getMedication().getAmountNumeratorString().orElseThrow());
    }

    @Test
    void testEncodingSingleKbvBundleFreetext() {
        String expectedID = "4863d1fb-dc26-4680-bb35-018610d1749d";
        String fileName = "4863d1fb-dc26-4680-bb35-018610d1749d.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/4863d1fb-dc26-4680-bb35-018610d1749d.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)MedicationType.FREETEXT, kbvBundle.getMedication().getMedicationType().orElseThrow());
        Assertions.assertFalse((boolean)kbvBundle.getMedication().getAmountNumeratorString().isPresent());
    }

    @Test
    void shouldEncodeSingleCompounding110Bundle() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals((Object)KbvItaErpVersion.V1_1_0, (Object)kbvBundle.getMedication().getVersion());
        KbvErpMedication medication = kbvBundle.getMedication();
        medication.getPackagingSize().ifPresentOrElse(amount -> Assertions.assertEquals((Object)"500", (Object)amount), () -> Assertions.fail((String)"Expected Packaging Amount not found"));
        medication.getPackagingUnit().ifPresentOrElse(unit -> Assertions.assertEquals((Object)"ml", (Object)unit), () -> Assertions.fail((String)"Expected Packaging Unit not found"));
        KbvErpMedicationRequest medicationRequest = kbvBundle.getMedicationRequest();
        Assertions.assertFalse((boolean)medicationRequest.isBvg());
        Assertions.assertFalse((boolean)medicationRequest.hasEmergencyServiceFee());
        Assertions.assertEquals((Object)MedicationType.COMPOUNDING, kbvBundle.getMedication().getMedicationType().orElseThrow());
        Assertions.assertFalse((boolean)kbvBundle.getMedication().getAmountNumeratorString().isPresent());
    }

    @Test
    void shouldFailOnMissingMedication() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        List<Bundle.BundleEntryComponent> medications = kbvBundle.getEntry().stream().filter(entry -> entry.getResource().getResourceType().equals((Object)ResourceType.Medication)).toList();
        kbvBundle.getEntry().removeAll(medications);
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvErpBundle)kbvBundle).getMedication());
    }

    @Test
    void shouldFailOnMissingPayorType() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        KbvCoverage coverage = kbvBundle.getCoverage();
        Assertions.assertTrue((boolean)coverage.getPayorType().isEmpty());
    }

    @Test
    void testChangeOfDates() {
        String expectedID = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String fileName = "1f339db0-9e55-4946-9dfa-f1b30953be9b.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Date origAuthoredOn = kbvBundle.getAuthoredOn();
        Date origCompositionDate = kbvBundle.getCompositionDate();
        Date origTimestamp = kbvBundle.getTimestamp();
        Date origLastUpdate = kbvBundle.getMeta().getLastUpdated();
        kbvBundle.setAllDates();
        Assertions.assertTrue((boolean)origAuthoredOn.before(kbvBundle.getAuthoredOn()));
        Assertions.assertTrue((boolean)origCompositionDate.before(kbvBundle.getCompositionDate()));
        Assertions.assertTrue((boolean)origTimestamp.before(kbvBundle.getTimestamp()));
        Assertions.assertTrue((boolean)origLastUpdate.before(kbvBundle.getMeta().getLastUpdated()));
    }

    @ParameterizedTest(name="{index} Change existing Coverage with {1}")
    @MethodSource
    void shouldChangeCoverageOnExistingBundle(String fileName, KbvItaForVersion version) {
        String content = ResourceLoader.readFileFromResource((String)fileName);
        IntStream.range(0, 2).forEach(idx -> {
            KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
            KbvCoverage oldCoverage = kbvBundle.getCoverage();
            String oldIknr = oldCoverage.getPayorFirstRep().getIdentifier().getValue();
            String oldName = oldCoverage.getPayorFirstRep().getDisplay();
            KbvCoverage newCoverage = null;
            while (newCoverage == null || ((String)newCoverage.getIknr().getValue()).equals(oldIknr)) {
                newCoverage = KbvCoverageFaker.builder().withInsuranceType(oldCoverage.getInsuranceKind()).withVersion(version).fake();
            }
            kbvBundle.changeCoverage(newCoverage);
            KbvCoverage nc2 = kbvBundle.getCoverage();
            String newIknr = nc2.getPayorFirstRep().getIdentifier().getValue();
            String newName = nc2.getPayorFirstRep().getDisplay();
            Assertions.assertNotEquals((Object)oldIknr, (Object)newIknr);
            Assertions.assertNotEquals((Object)oldName, (Object)newName);
            ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)kbvBundle);
            Assertions.assertTrue((boolean)result.isSuccessful());
        });
    }

    static Stream<Arguments> shouldChangeCoverageOnExistingBundle() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"fhir/valid/kbv/1.0.2/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml", KbvItaForVersion.V1_0_3}), Arguments.arguments((Object[])new Object[]{"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml", KbvItaForVersion.V1_0_3}), Arguments.arguments((Object[])new Object[]{"fhir/valid/kbv/1.1.0/bundle/1f339db0-9e55-4946-9dfa-f1b30953be9b.xml", KbvItaForVersion.V1_1_0}), Arguments.arguments((Object[])new Object[]{"fhir/valid/kbv/1.1.0/bundle/328ad940-3fff-11ed-b878-0242ac120002.xml", KbvItaForVersion.V1_1_0}));
    }

    @Test
    void shouldProvideOriginalPatientAsKbvErpPatient() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Resource originalPatient = kbvBundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Patient)).findFirst().orElseThrow(() -> new MissingFieldException(kbvBundle.getClass(), "Patient"));
        KbvPatient kbvPatient1 = kbvBundle.getPatient();
        KbvPatient kbvPatient2 = kbvBundle.getPatient();
        Assertions.assertEquals((Object)originalPatient, (Object)kbvPatient1);
        Assertions.assertEquals((Object)kbvPatient1, (Object)kbvPatient2);
        kbvPatient1.addExtension("abc", (Type)new StringType("xyz"));
        Assertions.assertEquals((int)1, (int)kbvPatient2.getExtensionsByUrl("abc").size());
    }

    @Test
    void shouldDecodeWithoutExpectedType() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        Resource bundle = parser.decode(content);
        Assertions.assertEquals((Object)ResourceType.Bundle, (Object)bundle.getResourceType());
        Assertions.assertEquals(KbvErpBundle.class, bundle.getClass());
    }

    @Test
    void shouldCopyWithBundleEntries() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertEquals(KbvErpMedicationRequest.class, kbvBundle.getMedicationRequest().getClass());
        KbvErpBundle copy = new KbvErpBundle();
        kbvBundle.copyValues((Bundle)copy);
        Assertions.assertEquals(KbvErpMedicationRequest.class, copy.getMedicationRequest().getClass());
    }

    @Test
    void shouldFailOnInappropriateExtensions() {
        Extension extension = new Extension("https://test.erp.gematik.de").setValue((Type)new StringType("Just a Testvalue"));
        List<ConsumerExpectation<KbvErpBundle>> extensionConsumer = List.of(ConsumerExpectation.from(bundle -> bundle.getComposition().addExtension(extension), "Extension in Composition", false), ConsumerExpectation.from(bundle -> bundle.getMedication().addExtension(extension), "Extension in Medication", false), ConsumerExpectation.from(bundle -> bundle.getMedicationRequest().addExtension(extension), "Extension in MedicationRequest", false), ConsumerExpectation.from(bundle -> bundle.getPatient().addExtension(extension), "Extension in Patient", false), ConsumerExpectation.from(bundle -> bundle.getCoverage().addExtension(extension), "Extension in Coverage", false));
        extensionConsumer.forEach(c -> {
            KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().withKvnr(KVNR.random()).withPrescriptionId(new PrescriptionId("160.002.362.150.600.45")).fake();
            c.accept(kbvBundle);
            String encoded = parser.encode((IBaseResource)kbvBundle, EncodingType.XML);
            ValidationResult result = parser.validate(encoded);
            Assertions.assertEquals((Object)c.expectedResult, (Object)result.isSuccessful(), (String)MessageFormat.format("Inappropriate {0} must result in {1} for KbvBundle in Version {2}", c.name, c.expectedResult, kbvBundle.getMetaProfileVersion()));
        });
    }

    @Test
    void testEncodingCodingSingleValidKbvBundleAsMedicationCompoundingAndCheckPZN() {
        String expectedID = "a409358a-da34-11eb-8d19-0242ac130003";
        String expectedPZN = "10206346";
        String fileName = "a409358a-da34-11eb-8d19-0242ac130003.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/a409358a-da34-11eb-8d19-0242ac130003.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertTrue((boolean)kbvBundle.getMedication().getPznOptional().isPresent());
        KbvErpMedication medication = kbvBundle.getMedication();
        Assertions.assertEquals((Object)"10206346", (Object)((PZN)medication.getPznOptional().get()).getValue());
        Assertions.assertEquals((Object)"Aluminiumchlorid-Hexahydrat", medication.getIngredientTextOptional().orElseThrow());
        Assertions.assertTrue((boolean)medication.getDarreichungsform().isEmpty());
    }

    @Test
    void shouldGetMedicationRequests() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().fake();
        Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)bundle).getMedicationRequests());
    }

    @Test
    void shouldGetFirstMedicationRequest() {
        KbvErpBundle bundle = KbvErpBundleFaker.builder().fake();
        Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)bundle).getFirstMedicationRequest());
    }

    @Test
    void shouldHandleMissingMedicationRequest() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        kbvBundle.getEntry().removeIf(entry -> entry.getResource().getResourceType().equals((Object)ResourceType.MedicationRequest));
        Assertions.assertTrue((boolean)kbvBundle.getMedicationRequestOptional().isEmpty());
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvErpBundle)kbvBundle).getMedicationRequest());
    }

    @Test
    void shouldFetchSupplyRequest() {
        String expectedID = "dae573db-54e3-4cb8-880d-0a46bea8aea1";
        String fileName = "dae573db-54e3-4cb8-880d-0a46bea8aea1.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.1.0/bundle/dae573db-54e3-4cb8-880d-0a46bea8aea1.xml");
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        kbvBundle.getEntry().add(new Bundle.BundleEntryComponent().setResource((Resource)new SupplyRequest()));
        Assertions.assertTrue((boolean)kbvBundle.getSupplyRequest().isPresent());
    }

    static class ConsumerExpectation<T> {
        private final Consumer<T> consumer;
        private final String name;
        private final boolean expectedResult;

        public void accept(T t) {
            this.consumer.accept(t);
        }

        public static <T> ConsumerExpectation<T> from(Consumer<T> consumer, String name, boolean expectedResult) {
            return new ConsumerExpectation<T>(consumer, name, expectedResult);
        }

        @Generated
        public ConsumerExpectation(Consumer<T> consumer, String name, boolean expectedResult) {
            this.consumer = consumer;
            this.name = name;
            this.expectedResult = expectedResult;
        }
    }
}

