/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.valuesets.DmpKennzeichen;
import java.util.Optional;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KbvCoverageTest {
    KbvCoverageTest() {
    }

    @Test
    void shouldGetFromResource() {
        Coverage resource = new Coverage();
        KbvCoverage kbvCoverage = KbvCoverage.fromCoverage((Resource)resource);
        Assertions.assertNotNull((Object)kbvCoverage);
        Assertions.assertNotEquals((Object)resource, (Object)kbvCoverage);
    }

    @Test
    void shouldNotCast() {
        Coverage resource = new Coverage();
        KbvCoverage kbvCoverage = KbvCoverage.fromCoverage((Coverage)resource);
        KbvCoverage kbvCoverage2 = KbvCoverage.fromCoverage((Coverage)kbvCoverage);
        Assertions.assertEquals((Object)kbvCoverage, (Object)kbvCoverage2);
    }

    @Test
    void shouldThrowOnMissingInsuranceKind() {
        KbvCoverage coverage = (KbvCoverage)Mockito.mock(KbvCoverage.class);
        Mockito.when((Object)coverage.getInsuranceKindOptional()).thenReturn(Optional.empty());
        Mockito.when((Object)coverage.getInsuranceKind()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvCoverage)coverage).getInsuranceKind());
    }

    @Test
    void shouldThrowOnMissingInsurantState() {
        KbvCoverage coverage = (KbvCoverage)Mockito.mock(KbvCoverage.class);
        Mockito.when((Object)coverage.getInsurantStateOptional()).thenReturn(Optional.empty());
        Mockito.when((Object)coverage.getInsurantState()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvCoverage)coverage).getInsurantState());
    }

    @Test
    void shouldThrowOnMissingPersonGroup() {
        KbvCoverage coverage = (KbvCoverage)Mockito.mock(KbvCoverage.class);
        Mockito.when((Object)coverage.getPersonGroupOptional()).thenReturn(Optional.empty());
        Mockito.when((Object)coverage.getPersonGroup()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvCoverage)coverage).getPersonGroup());
    }

    @Test
    void shouldReturnDmpKennzeichen() {
        KbvCoverage coverage = (KbvCoverage)Mockito.mock(KbvCoverage.class);
        Mockito.when((Object)coverage.getDmpKennzeichenOptional()).thenReturn(Optional.of(DmpKennzeichen.DM1));
        Mockito.when((Object)coverage.getDmpKennzeichen()).thenCallRealMethod();
        Assertions.assertDoesNotThrow(() -> ((KbvCoverage)coverage).getDmpKennzeichen());
        KbvCoverage coverage2 = new KbvCoverage();
        Assertions.assertEquals(Optional.empty(), (Object)coverage2.getDmpKennzeichenOptional());
    }

    @Test
    void shouldThrowOnMissingDmpKennzeichen() {
        KbvCoverage coverage = (KbvCoverage)Mockito.mock(KbvCoverage.class);
        Mockito.when((Object)coverage.getDmpKennzeichenOptional()).thenReturn(Optional.empty());
        Mockito.when((Object)coverage.getDmpKennzeichen()).thenCallRealMethod();
        Assertions.assertThrows(MissingFieldException.class, () -> ((KbvCoverage)coverage).getDmpKennzeichen());
    }
}

