/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvBasePatientTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/kbv/1.0.2/patient/";

    KbvBasePatientTest() {
    }

    @Test
    void encodeErwinFischer() {
        String fileExtension = ".xml";
        String fileName = "erwin_fleischer.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/patient/erwin_fleischer.xml");
        KbvPatient erwin = (KbvPatient)parser.decode(KbvPatient.class, content);
        Assertions.assertNotNull((Object)erwin);
        String expectedID = "9774f67f-a238-4daf-b4e6-679deeef3811";
        Assertions.assertEquals((Object)"9774f67f-a238-4daf-b4e6-679deeef3811", (Object)erwin.getLogicalId());
        Enumerations.AdministrativeGender expectedGender = Enumerations.AdministrativeGender.MALE;
        Assertions.assertEquals((Object)expectedGender, (Object)erwin.getGender());
        Assertions.assertTrue((boolean)erwin.hasGkvKvnr());
        String expectedGkvKvnr = "M234567890";
        Assertions.assertEquals((Object)"M234567890", (Object)((KVNR)erwin.getGkvId().orElseThrow()).getValue());
        Assertions.assertEquals((Object)"Fleischer, Erwin", (Object)erwin.getFullname());
        Assertions.assertNotNull((Object)erwin.getDescription());
    }

    @Test
    void shouldGetKbvPatientFromResource() {
        String fileExtension = ".xml";
        String fileName = "erwin_fleischer.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/patient/erwin_fleischer.xml");
        Resource erwin = parser.decode(content);
        Assertions.assertNotNull((Object)erwin);
        Assertions.assertEquals(Patient.class, erwin.getClass());
        KbvPatient kbvPatient = KbvPatient.fromPatient((Resource)erwin);
        Assertions.assertNotNull((Object)kbvPatient);
        Assertions.assertEquals(KbvPatient.class, kbvPatient.getClass());
    }
}

