/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.kbv;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.kbv.AssignerOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AssignerOrganizationTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_0_2 = "fhir/valid/kbv/1.0.2/bundle/";

    AssignerOrganizationTest() {
    }

    @Test
    void shouldGenerateAssignerOrganizationFromResource() {
        Organization resource = new Organization();
        AssignerOrganization assigner = AssignerOrganization.fromOrganization((Organization)resource);
        Assertions.assertNotNull((Object)assigner);
        Assertions.assertEquals(AssignerOrganization.class, assigner.getClass());
    }

    @Test
    void shouldRecastFromMedicalOrganization() {
        String expectedID = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6";
        String fileName = "sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/kbv/1.0.2/bundle/sdf6s75f-d959-43f0-8ac4-sd6f7sd6.xml");
        Assertions.assertTrue((boolean)parser.isValid(content));
        KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
        Assertions.assertTrue((boolean)kbvBundle.getAssignerOrganization().isPresent());
        AssignerOrganization assignerOrg = (AssignerOrganization)kbvBundle.getAssignerOrganization().orElseThrow();
        AssignerOrganization assignerOrg2 = AssignerOrganization.fromOrganization((Resource)assignerOrg);
        Assertions.assertEquals((Object)assignerOrg, (Object)assignerOrg2);
    }
}

