/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.test.erezept.fhir.exceptions.InvalidCommunicationType;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.ErpWorkflowStructDef;
import de.gematik.test.erezept.fhir.r4.erp.CommunicationType;
import de.gematik.test.erezept.fhir.r4.erp.ICommunicationType;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ICommunicationTypeTest {
    ICommunicationTypeTest() {
    }

    @Test
    void shouldGetCommunicationTypeFromUrl() {
        List<CommunicationType> types = Arrays.asList(CommunicationType.values());
        types.forEach(type -> {
            String url = type.getTypeUrl();
            Assertions.assertEquals((Object)type, (Object)ICommunicationType.fromUrl((String)url));
        });
    }

    @ParameterizedTest(name="[{index}] -> Create CommunicationType from StructureDefinition {0}")
    @EnumSource(value=ErpWorkflowStructDef.class, names={"COM_INFO_REQ_12", "COM_DISP_REQ_12", "COM_REPLY_12", "COM_REPRESENTATIVE_12"})
    void shouldGetNewCommunicationTypesFromUrl(ErpWorkflowStructDef structDef) {
        String url = structDef.getCanonicalUrl();
        Assertions.assertDoesNotThrow(() -> ICommunicationType.fromUrl((String)url));
    }

    @Test
    void shouldThrowOnInvalidFromUrl() {
        Assertions.assertThrows(InvalidCommunicationType.class, () -> ICommunicationType.fromUrl((String)"invalid_url"));
    }
}

