/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.date.DateConverter;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.r4.erp.ErxTask;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.values.Secret;
import de.gematik.test.erezept.fhir.valuesets.PerformerType;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.r4.model.Task;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxTaskTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/";
    private static final String BASE_PATH_1_1_1 = "fhir/valid/erp/1.1.1/";
    private static final String BASE_PATH_1_2_0 = "fhir/valid/erp/1.2.0/task/";
    private static final String BASE_PATH_1_3_0 = "fhir/valid/erp/1.3.0/task/";

    ErxTaskTest() {
    }

    @Test
    void shouldEncodeSingleTask111() {
        String fileName = "Task_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Task_01.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        String expectedId = "16aaabf2-1de1-11b2-8057-a3c264e57515";
        Assertions.assertEquals((Object)"16aaabf2-1de1-11b2-8057-a3c264e57515", (Object)task.getTaskId().getValue());
        PrescriptionId expectedPrescriptionID = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, "160.002.266.580.400.82");
        Assertions.assertEquals((Object)expectedPrescriptionID, (Object)task.getPrescriptionId());
        PrescriptionFlowType expectedFlowType = PrescriptionFlowType.FLOW_TYPE_160;
        Assertions.assertEquals((Object)expectedFlowType, (Object)task.getFlowType());
        AccessCode expectedAccessCode = new AccessCode("8d7d61c14e3e24c79d17dbe4ef0fc3cf9356cbfa07aecb593246314434606642");
        Assertions.assertTrue((boolean)task.hasAccessCode());
        Assertions.assertEquals((Object)expectedAccessCode, (Object)task.getAccessCode());
        Assertions.assertFalse((boolean)task.hasSecret());
        Task.TaskStatus expectedStatus = Task.TaskStatus.DRAFT;
        Assertions.assertEquals((Object)expectedStatus, (Object)task.getStatus());
        Assertions.assertTrue((boolean)task.getForKvnr().isEmpty());
        PerformerType expectedPerformer = PerformerType.PUBLIC_PHARMACY;
        Assertions.assertEquals((Object)expectedPerformer, (Object)task.getPerformerFirstRep());
        Task.TaskIntent expectedIntent = Task.TaskIntent.ORDER;
        Assertions.assertEquals((Object)expectedIntent, (Object)task.getIntent());
        Assertions.assertFalse((boolean)task.hasLastMedicationDispenseDate());
        Assertions.assertNotNull((Object)task.toString());
    }

    @Test
    void shouldEncodeExpiryAndAcceptDates() {
        String fileName = "Task_03.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Task_03.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        DateConverter dc = DateConverter.getInstance();
        Date expectedExpiry = dc.dateFromIso8601("2020-05-02");
        Date expectedAccept = dc.dateFromIso8601("2020-03-02");
        Assertions.assertEquals((Object)expectedExpiry, (Object)task.getExpiryDate());
        Assertions.assertEquals((Object)expectedAccept, (Object)task.getAcceptDate());
    }

    @Test
    void shouldEncodeSingleTask120() {
        String fileName = "160_000_031_325_714_07.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/task/160_000_031_325_714_07.json");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        String expectedId = "160.000.031.325.714.07";
        Assertions.assertEquals((Object)"160.000.031.325.714.07", (Object)task.getTaskId().getValue());
        PrescriptionId expectedPrescriptionID = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID_121, "160.000.031.325.714.07");
        Assertions.assertEquals((Object)expectedPrescriptionID, (Object)task.getPrescriptionId());
        PrescriptionFlowType expectedFlowType = PrescriptionFlowType.FLOW_TYPE_160;
        Assertions.assertEquals((Object)expectedFlowType, (Object)task.getFlowType());
        AccessCode expectedAccessCode = new AccessCode("d9fb6f72947ae4d85e1e5c9c8a00502975cb3d5efe3321f079890c829eeeb7ae");
        Assertions.assertTrue((boolean)task.hasAccessCode());
        Assertions.assertEquals((Object)expectedAccessCode, task.getOptionalAccessCode().orElseThrow());
        Assertions.assertFalse((boolean)task.hasSecret());
        Task.TaskStatus expectedStatus = Task.TaskStatus.READY;
        Assertions.assertEquals((Object)expectedStatus, (Object)task.getStatus());
        Assertions.assertTrue((boolean)task.getForKvnr().isPresent());
        Assertions.assertEquals((Object)"X110498565", (Object)((KVNR)task.getForKvnr().orElseThrow()).getValue());
        PerformerType expectedPerformer = PerformerType.PUBLIC_PHARMACY;
        Assertions.assertEquals((Object)expectedPerformer, (Object)task.getPerformerFirstRep());
        Task.TaskIntent expectedIntent = Task.TaskIntent.ORDER;
        Assertions.assertEquals((Object)expectedIntent, (Object)task.getIntent());
        DateConverter dc = DateConverter.getInstance();
        Date expectedExpiry = dc.dateFromIso8601("2023-04-25");
        Date expectedAccept = dc.dateFromIso8601("2023-02-22");
        Assertions.assertEquals((Object)expectedExpiry, (Object)task.getExpiryDate());
        Assertions.assertEquals((Object)expectedAccept, (Object)task.getAcceptDate());
        Assertions.assertNotNull((Object)task.toString());
    }

    @Test
    void shouldThrowMissingFieldExceptionWhenNoDatesGiven() {
        ErxTask task = new ErxTask();
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxTask)task).getExpiryDate());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxTask)task).getAcceptDate());
    }

    @Test
    void shouldEncodeSinglePkvDraftTask120() {
        String fileName = "209_000_000_000_035_71.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/task/209_000_000_000_035_71.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        String expectedId = "209.000.000.000.035.71";
        Assertions.assertEquals((Object)"209.000.000.000.035.71", (Object)task.getTaskId().getValue());
        PrescriptionId expectedPrescriptionID = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID_121, "209.000.000.000.035.71");
        Assertions.assertEquals((Object)expectedPrescriptionID, (Object)task.getPrescriptionId());
        PrescriptionFlowType expectedFlowType = PrescriptionFlowType.FLOW_TYPE_209;
        Assertions.assertEquals((Object)expectedFlowType, (Object)task.getFlowType());
        AccessCode expectedAccessCode = new AccessCode("b7bc799dd564e3ae10e79b3558154daa720c190613809088b964d090ec9ed2c2");
        Assertions.assertTrue((boolean)task.hasAccessCode());
        Assertions.assertEquals((Object)expectedAccessCode, task.getOptionalAccessCode().orElseThrow());
        Assertions.assertFalse((boolean)task.hasSecret());
        Task.TaskStatus expectedStatus = Task.TaskStatus.DRAFT;
        Assertions.assertEquals((Object)expectedStatus, (Object)task.getStatus());
        Assertions.assertTrue((boolean)task.getForKvnr().isEmpty());
        PerformerType expectedPerformer = PerformerType.PUBLIC_PHARMACY;
        Assertions.assertEquals((Object)expectedPerformer, (Object)task.getPerformerFirstRep());
        Task.TaskIntent expectedIntent = Task.TaskIntent.ORDER;
        Assertions.assertEquals((Object)expectedIntent, (Object)task.getIntent());
        Assertions.assertNotNull((Object)task.toString());
    }

    @Test
    void shouldHaveSecret() {
        String fileName = "Task_03";
        List<String> fileExtensions = List.of(".xml", ".json");
        fileExtensions.stream().map(ext -> ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/Task_03" + ext))).forEach(content -> {
            Secret expectedSecret = new Secret("c36ca26502892b371d252c99b496e31505ff449aca9bc69e231c58148f6233cf");
            ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
            Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
            Assertions.assertTrue((boolean)task.hasSecret());
            Assertions.assertTrue((boolean)task.hasAccessCode());
            Assertions.assertEquals((Object)expectedSecret, task.getSecret().orElseThrow());
        });
    }

    @Test
    void shouldHaveLastMedicationDispenseInstan() throws ParseException {
        String fileName = "9b48f82c-9c11-4a57-aa72-a805f9537a82.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.3.0/task/9b48f82c-9c11-4a57-aa72-a805f9537a82.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        Assertions.assertTrue((boolean)task.hasLastMedicationDispenseDate());
        Instant lmd = (Instant)task.getLastMedicationDispenseDate().orElseThrow();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        Instant expectation = formatter.parse("2022-05-20T13:28:17+02:00").toInstant();
        Assertions.assertEquals((Object)expectation, (Object)lmd);
    }

    @Test
    void shouldThrowOnMissingFields() {
        String fileName = "Task_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Task_01.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        task.setIdentifier(List.of());
        task.setExtension(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxTask)task).getPrescriptionId());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxTask)task).getFlowType());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxTask)task).getAccessCode());
    }

    @Test
    void shouldGenerateErxTaskFromResource() {
        Task resource = new Task();
        ErxTask erxTask = ErxTask.fromTask((Task)resource);
        Assertions.assertNotNull((Object)erxTask);
        Assertions.assertEquals(ErxTask.class, erxTask.getClass());
    }

    @Test
    void shouldReturnEmptyWhenLastMedicationDispenseDateIsAbsent() {
        String fileName = "Task_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Task_01.xml");
        ErxTask task = (ErxTask)parser.decode(ErxTask.class, content);
        Assertions.assertNotNull((Object)task, (String)"Valid ErxTask must be parseable");
        Assertions.assertFalse((boolean)task.getLastMedicationDispenseDateElement().isPresent());
    }
}

