/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxTask;
import de.gematik.test.erezept.fhir.r4.erp.ErxTaskBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxTaskBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.1.1/";

    ErxTaskBundleTest() {
    }

    @Test
    void shouldGetAllTasksFromBundle() {
        String fileName = "TaskBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/TaskBundle_01.json");
        ErxTaskBundle bundle = (ErxTaskBundle)parser.decode(ErxTaskBundle.class, content);
        Assertions.assertNotNull((Object)bundle, (String)"Valid ErxTaskBundle must be parseable");
        Assertions.assertEquals((int)50, (int)bundle.getTasks().size());
    }

    @Test
    void shouldGetLatestTask() {
        String fileName = "TaskBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/TaskBundle_01.json");
        ErxTaskBundle bundle = (ErxTaskBundle)parser.decode(ErxTaskBundle.class, content);
        Assertions.assertNotNull((Object)bundle, (String)"Valid ErxTaskBundle must be parseable");
        ErxTask latestTask = bundle.getLatestTask();
        Assertions.assertEquals((Object)"160.000.006.259.611.36", (Object)latestTask.getPrescriptionId().getValue());
    }
}

