/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.r4.erp.ErxReceipt;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.DocumentType;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Resource;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxReceiptTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.1.1/";

    ErxReceiptTest() {
    }

    @Test
    void shouldEncodeSingleReceipt() {
        String fileName = "Receipt_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Receipt_01.xml");
        ErxReceipt receipt = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Assertions.assertNotNull((Object)receipt, (String)"Valid ErxReceipt must be parseable");
        Assertions.assertEquals((Object)new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, "160.123.456.789.123.58"), (Object)receipt.getPrescriptionId());
        Assertions.assertEquals((Object)DocumentType.RECEIPT, (Object)receipt.getDocumentType());
    }

    @Test
    void shouldCreateFromResource() {
        String fileName = "Receipt_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Receipt_01.xml");
        Resource receiptResource = parser.decode(Bundle.class, content);
        Assertions.assertNotNull((Object)receiptResource, (String)"Valid ErxReceipt must be parseable");
        ErxReceipt erxReceipt = ErxReceipt.fromBundle((Resource)receiptResource);
        Assertions.assertEquals((Object)new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, "160.123.456.789.123.58"), (Object)erxReceipt.getPrescriptionId());
    }

    @Test
    void shouldThrowMissingFieldException() {
        String fileName = "Receipt_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Receipt_01.xml");
        ErxReceipt receiptResource = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        receiptResource.getComposition().setType(null);
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxReceipt)receiptResource).getDocumentType());
    }

    @Test
    void getDocumentTypeShouldWork() {
        String fileName = "NeueVersion_0e0f861-0000-0000-0003-000000000000.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/receiptbundle/NeueVersion_0e0f861-0000-0000-0003-000000000000.xml");
        ErxReceipt receipt = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Assertions.assertNotNull((Object)receipt.getDocumentType());
        Assertions.assertEquals((Object)DocumentType.RECEIPT, (Object)receipt.getDocumentType());
    }

    @Test
    void getCompositionShouldWork() {
        String fileName = "dffbfd6a-5712-4798-bdc8-07201eb77ab8.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/receiptbundle/dffbfd6a-5712-4798-bdc8-07201eb77ab8.xml");
        ErxReceipt receipt = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Assertions.assertNotNull((Object)receipt.getComposition());
        Assertions.assertEquals((Object)Composition.CompositionStatus.FINAL, (Object)receipt.getComposition().getStatus());
    }

    @Test
    void getAuthorShouldWork() {
        String fileName = "NeueVersion_0e0f861-0000-0000-0003-000000000000.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/receiptbundle/NeueVersion_0e0f861-0000-0000-0003-000000000000.xml");
        ErxReceipt receipt = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Assertions.assertNotNull((Object)receipt.getAuthor());
        Assert.assertTrue((boolean)receipt.getAuthor().getReference().startsWith("urn:uuid:"));
    }

    @Test
    void getSectionShouldWork() {
        String fileName = "NeueVersion_0e0f861-0000-0000-0003-000000000000.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/receiptbundle/NeueVersion_0e0f861-0000-0000-0003-000000000000.xml");
        ErxReceipt receipt = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Assertions.assertNotNull((Object)receipt.getQesDigestRefInComposSect());
        Assert.assertTrue((boolean)receipt.getQesDigestRefInComposSect().getEntryFirstRep().getReference().startsWith("urn:uuid:"));
    }

    @Test
    void getPrescriptionDigitShouldWork() {
        Binary binary;
        String fileName = "org_fd_response.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/receiptbundle/org_fd_response.xml");
        ErxReceipt bundle = (ErxReceipt)parser.decode(ErxReceipt.class, content);
        Binary code = binary = bundle.getQesDigestBinary();
        Assertions.assertEquals((Object)"eNMcZvslUsx75vwaQd4McWdHcfjHELsX/y02wsbRjlo=", (Object)code.getContentAsBase64());
    }
}

