/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxPrescriptionBundle;
import de.gematik.test.erezept.fhir.r4.erp.ErxReceipt;
import de.gematik.test.erezept.fhir.r4.erp.ErxTask;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.DocumentType;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxPrescriptionBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/";
    private static final String BASE_PATH_1_1_1 = "fhir/valid/erp/1.1.1/";
    private static final String BASE_PATH_1_2_0 = "fhir/valid/erp/1.2.0/prescriptionbundle/";

    ErxPrescriptionBundleTest() {
    }

    @Test
    void shouldEncodeSinglePrescriptionBundle111() {
        String fileName = "PrescriptionBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/PrescriptionBundle_01.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        Assertions.assertNotNull((Object)prescriptionBundle, (String)"Valid ErxPrescriptionBundle must be parseable");
        ErxTask task = prescriptionBundle.getTask();
        Assertions.assertNotNull((Object)task);
        Assertions.assertEquals((Object)"169.000.000.006.874.07", (Object)task.getPrescriptionId().getValue());
        Optional kbvBundle = prescriptionBundle.getKbvBundle();
        Assertions.assertNotNull((Object)kbvBundle);
        Assertions.assertTrue((boolean)kbvBundle.isPresent());
        kbvBundle.ifPresent(kbvErpBundle -> Assertions.assertEquals((Object)"169.000.000.006.874.07", (Object)kbvErpBundle.getPrescriptionId().getValue()));
        kbvBundle.ifPresent(kbvErpBundle -> Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_169, (Object)((KbvErpBundle)kbvBundle.get()).getFlowType()));
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_169, (Object)task.getFlowType());
        Optional receipt = prescriptionBundle.getReceipt();
        Assertions.assertTrue((boolean)receipt.isEmpty());
    }

    @Test
    void shouldEncodeSinglePrescriptionBundle120() {
        String fileName = "51fe2824-aed7-4f6a-803b-3e351137d998.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/prescriptionbundle/51fe2824-aed7-4f6a-803b-3e351137d998.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        Assertions.assertNotNull((Object)prescriptionBundle, (String)"Valid ErxPrescriptionBundle must be parseable");
        ErxTask task = prescriptionBundle.getTask();
        Assertions.assertNotNull((Object)task);
        Assertions.assertEquals((Object)"160.000.031.325.714.07", (Object)task.getPrescriptionId().getValue());
        Optional kbvBundle = prescriptionBundle.getKbvBundle();
        Assertions.assertNotNull((Object)kbvBundle);
        kbvBundle.ifPresent(kbvErpBundle -> Assertions.assertEquals((Object)"160.000.031.325.714.07", (Object)kbvErpBundle.getPrescriptionId().getValue()));
        kbvBundle.ifPresent(kbvErpBundle -> Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_160, (Object)((KbvErpBundle)kbvBundle.get()).getFlowType()));
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_160, (Object)task.getFlowType());
        Optional receipt = prescriptionBundle.getReceipt();
        Assertions.assertTrue((boolean)receipt.isEmpty());
    }

    @Test
    void shouldGetKbvBundleFromPrescriptionBundle120() {
        String fileName = "51fe2824-aed7-4f6a-803b-3e351137d998.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/prescriptionbundle/51fe2824-aed7-4f6a-803b-3e351137d998.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        Assertions.assertNotNull((Object)prescriptionBundle, (String)"Valid ErxPrescriptionBundle must be parseable");
        Assertions.assertDoesNotThrow(() -> ((ErxPrescriptionBundle)prescriptionBundle).getKbvBundle());
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getPatient()));
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getMedication()));
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getMedicationRequest()));
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getMedicalOrganization()));
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getCoverage()));
        prescriptionBundle.getKbvBundle().ifPresent(kbvErpBundle -> Assertions.assertDoesNotThrow(() -> ((KbvErpBundle)kbvErpBundle).getPractitioner()));
        Assertions.assertDoesNotThrow(() -> ((ErxPrescriptionBundle)prescriptionBundle).getTask());
        Assertions.assertDoesNotThrow(() -> ((ErxTask)prescriptionBundle.getTask()).getAcceptDate());
    }

    @Test
    void shouldEncodeSinglePrescriptionBundleXml120() {
        String fileName = "d95b3ece-cdd7-439d-a062-17bdc2253962.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/prescriptionbundle/d95b3ece-cdd7-439d-a062-17bdc2253962.xml");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        Assertions.assertNotNull((Object)prescriptionBundle, (String)"Valid ErxPrescriptionBundle must be parseable");
        ErxTask task = prescriptionBundle.getTask();
        Assertions.assertNotNull((Object)task);
        Assertions.assertEquals((Object)"160.000.031.325.889.64", (Object)task.getPrescriptionId().getValue());
        Assertions.assertEquals((Object)PrescriptionFlowType.FLOW_TYPE_160, (Object)task.getFlowType());
        Optional receipt = prescriptionBundle.getReceipt();
        Assertions.assertTrue((boolean)receipt.isPresent());
        DocumentType docType = ((ErxReceipt)receipt.orElseThrow()).getDocumentType();
        Assertions.assertEquals((Object)DocumentType.RECEIPT, (Object)docType);
    }

    @Test
    void shouldFailOnMissingTask() {
        String fileName = "PrescriptionBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/PrescriptionBundle_01.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        List<Bundle.BundleEntryComponent> taskResources = prescriptionBundle.getEntry().stream().filter(resource -> resource.getResource().getResourceType().equals((Object)ResourceType.Task)).toList();
        prescriptionBundle.getEntry().removeAll(taskResources);
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxPrescriptionBundle)prescriptionBundle).getTask());
    }

    @Test
    void shouldFailOnMissingKbvBundle() {
        String fileName = "PrescriptionBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/PrescriptionBundle_01.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        List<Bundle.BundleEntryComponent> kbvBundleResources = prescriptionBundle.getEntry().stream().filter(resource -> resource.getResource().getResourceType().equals((Object)ResourceType.Bundle)).toList();
        prescriptionBundle.getEntry().removeAll(kbvBundleResources);
        Assertions.assertTrue((boolean)prescriptionBundle.getKbvBundle().isEmpty());
    }

    @Test
    void shouldFailOnInvalidKbvBundle() {
        String fileName = "PrescriptionBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/PrescriptionBundle_01.json");
        ErxPrescriptionBundle prescriptionBundle = (ErxPrescriptionBundle)parser.decode(ErxPrescriptionBundle.class, content);
        prescriptionBundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resource -> resource.getResourceType().equals((Object)ResourceType.Bundle)).forEach(bundle -> ((CanonicalType)bundle.getMeta().getProfile().get(0)).setValueAsString("invalid profile!"));
        Assertions.assertTrue((boolean)prescriptionBundle.getKbvBundle().isEmpty());
    }
}

