/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispense;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.Darreichungsform;
import de.gematik.test.erezept.fhir.valuesets.MedicationCategory;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxMedicationDispenseTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.1.1/";

    ErxMedicationDispenseTest() {
    }

    @Test
    void shouldEncodeSingleMedicationDispense() {
        String fileName = "MedicationDispense_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/MedicationDispense_01.xml");
        ErxMedicationDispense medicationDispense = (ErxMedicationDispense)parser.decode(ErxMedicationDispense.class, content);
        Assertions.assertNotNull((Object)medicationDispense, (String)"Valid MedicationDispense must be parseable");
        Assertions.assertEquals((Object)"12345678", (Object)medicationDispense.getPrescriptionId().getValue());
        Assertions.assertFalse((boolean)medicationDispense.isDiGA());
        KbvErpMedication medication = medicationDispense.getContainedKbvMedicationFirstRep();
        Assertions.assertNotNull((Object)medication, (String)"MedicationDispense must contain at leas one Medication");
        Assertions.assertEquals((Object)MedicationCategory.C_00, (Object)medication.getCategoryFirstRep());
        Assertions.assertFalse((boolean)medication.isVaccine());
        Assertions.assertEquals((Object)"06313728", (Object)medication.getPznFirstRep());
        Assertions.assertEquals((Object)"Sumatriptan-1a Pharma 100 mg Tabletten", (Object)medication.getMedicationName());
        Assertions.assertEquals((Object)Darreichungsform.TAB, medication.getDarreichungsform().orElseThrow());
        Assertions.assertEquals((Object)"X234567890", (Object)medicationDispense.getSubjectId().getValue());
        Assertions.assertEquals((Object)"606358757", (Object)medicationDispense.getPerformerIdFirstRep());
        ZonedDateTime expectedHandedOver = ZonedDateTime.of(2020, 3, 20, 3, 13, 0, 0, ZoneId.systemDefault());
        Assertions.assertEquals((Object)expectedHandedOver, (Object)medicationDispense.getZonedWhenHandedOver());
        Assertions.assertEquals((Object)"1-0-1-0", (Object)medicationDispense.getDosageInstructionTextFirstRep());
    }

    @Test
    void shouldCastFromMedicationDispense() {
        String fileName = "MedicationDispense_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/MedicationDispense_01.xml");
        Resource medicationDispense = parser.decode(MedicationDispense.class, content);
        ErxMedicationDispense erxMedicationDispense = ErxMedicationDispense.fromMedicationDispense((Resource)medicationDispense);
        Assertions.assertNotNull((Object)erxMedicationDispense);
    }
}

