/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispenseDiGA;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.List;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxMedicationDispenseDiGATest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.4.0/medicationdispense/";

    ErxMedicationDispenseDiGATest() {
    }

    @Test
    void shouldDecodeSingleDiGAMedicationDispense() {
        String fileName = "MedicationDispense-DiGA-DeepLink.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispense/MedicationDispense-DiGA-DeepLink.json");
        ErxMedicationDispenseDiGA medicationDispense = (ErxMedicationDispenseDiGA)parser.decode(ErxMedicationDispenseDiGA.class, content);
        Assertions.assertTrue((boolean)medicationDispense.isDiGA());
        Assertions.assertEquals((Object)new PrescriptionId("162.000.033.491.280.69"), (Object)medicationDispense.getPrescriptionId());
    }

    @Test
    void shouldDecodeDiGAMedicationDispenseWithoutType() {
        String fileName = "MedicationDispense-DiGA-Name-And-PZN.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispense/MedicationDispense-DiGA-Name-And-PZN.json");
        Resource medicationDispense = parser.decode(content);
        Assertions.assertInstanceOf(ErxMedicationDispenseDiGA.class, (Object)medicationDispense);
    }

    @Test
    void shouldThrowOnMissingPznAndName() {
        String fileName = "MedicationDispense-DiGA-DeepLink.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispense/MedicationDispense-DiGA-DeepLink.json");
        ErxMedicationDispenseDiGA medicationDispense = (ErxMedicationDispenseDiGA)parser.decode(ErxMedicationDispenseDiGA.class, content);
        medicationDispense.setMedication(null);
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxMedicationDispenseDiGA)medicationDispense).getPzn());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxMedicationDispenseDiGA)medicationDispense).getDigaName());
    }

    @Test
    void shouldThrowOnMissingPerformer() {
        String fileName = "MedicationDispense-DiGA-DeepLink.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispense/MedicationDispense-DiGA-DeepLink.json");
        ErxMedicationDispenseDiGA medicationDispense = (ErxMedicationDispenseDiGA)parser.decode(ErxMedicationDispenseDiGA.class, content);
        medicationDispense.setPerformer(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxMedicationDispenseDiGA)medicationDispense).getPerformerIdFirstRep());
    }
}

