/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxMedicationDispenseBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ErxMedicationDispenseBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.1.1/";
    private static final String BASE_PATH_1_4 = "fhir/valid/erp/1.4.0/medicationdispensebundle/";

    ErxMedicationDispenseBundleTest() {
    }

    @Test
    void shouldCastFromMedicationDispense() {
        String fileName = "MedicationDispenseBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/MedicationDispenseBundle_01.json");
        ValidationResult vr = parser.validate(content);
        if (!vr.isSuccessful()) {
            System.out.println(MessageFormat.format("Found {0} errors in {1}", vr.getMessages().size(), "fhir/valid/erp/1.1.1/MedicationDispenseBundle_01.json"));
            vr.getMessages().forEach(System.out::println);
        }
        Assertions.assertTrue((boolean)vr.isSuccessful(), (String)MessageFormat.format("{0} must be valid, but is not", "MedicationDispenseBundle_01.json"));
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        Assertions.assertNotNull((Object)bundle);
        Assertions.assertEquals((int)3, (int)bundle.getMedicationDispenses().size());
    }

    static Stream<Arguments> shouldReadGemMedicationsFromBundle() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"Bundle-SimpleMedicationDispenseBundle.json", 1, 1}), Arguments.arguments((Object[])new Object[]{"Bundle-KomplexMedicationDispenseBundle.json", 1, 1}), Arguments.arguments((Object[])new Object[]{"Bundle-MultipleMedicationDispenseBundle.json", 2, 2}), Arguments.arguments((Object[])new Object[]{"Bundle-SearchSetMultipleMedicationDispenseBundle.json", 2, 4}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldReadGemMedicationsFromBundle(String fileName, int expectedMedications, int expectedMedicationDispenses) {
        String content = ResourceLoader.readFileFromResource((String)(BASE_PATH_1_4 + fileName));
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        Assertions.assertEquals((int)expectedMedications, (int)bundle.getMedications().size());
        Assertions.assertEquals((int)expectedMedicationDispenses, (int)bundle.getMedicationDispenses().size());
    }

    static Stream<Arguments> shouldReadDispensationPairsByPrescriptionId() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.01"), "Bundle-SimpleMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.01"), "Bundle-MultipleMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.02"), "Bundle-MultipleMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.03"), "Bundle-KomplexMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.01"), "Bundle-SearchSetMultipleMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.02"), "Bundle-SearchSetMultipleMedicationDispenseBundle.json", 1}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldReadDispensationPairsByPrescriptionId(PrescriptionId prescriptionId, String fileName, int expectedMedications) {
        String content = ResourceLoader.readFileFromResource((String)(BASE_PATH_1_4 + fileName));
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        List pairs = (List)Assertions.assertDoesNotThrow(() -> bundle.getDispensePairBy(prescriptionId));
        Assertions.assertEquals((int)expectedMedications, (int)pairs.size());
    }

    static Stream<Arguments> shouldUnpackOldMedicationDispenses() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.04"), "Bundle-SearchSetMultipleMedicationDispenseBundle.json", 1}), Arguments.arguments((Object[])new Object[]{PrescriptionId.from((String)"160.000.000.000.000.05"), "Bundle-SearchSetMultipleMedicationDispenseBundle.json", 1}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldUnpackOldMedicationDispenses(PrescriptionId prescriptionId, String fileName, int expectedMedications) {
        String content = ResourceLoader.readFileFromResource((String)(BASE_PATH_1_4 + fileName));
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        List pairs = (List)Assertions.assertDoesNotThrow(() -> bundle.unpackDispensePairBy(prescriptionId));
        Assertions.assertEquals((int)expectedMedications, (int)pairs.size());
    }

    @Test
    void shouldThrowOnUnpackingNewMedicationDispensesByPrescriptionId() {
        PrescriptionId prescriptionId = PrescriptionId.from((String)"160.000.000.000.000.01");
        String fileName = "Bundle-SimpleMedicationDispenseBundle.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispensebundle/Bundle-SimpleMedicationDispenseBundle.json");
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        Assertions.assertThrows(RuntimeException.class, () -> bundle.unpackDispensePairBy(prescriptionId));
    }

    @Test
    void shouldThrowOnGettingOldMedicationDispensesByPrescriptionId() {
        PrescriptionId prescriptionId = PrescriptionId.from((String)"160.000.000.000.000.04");
        String fileName = "Bundle-SearchSetMultipleMedicationDispenseBundle.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispensebundle/Bundle-SearchSetMultipleMedicationDispenseBundle.json");
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        Assertions.assertThrows(RuntimeException.class, () -> bundle.getDispensePairBy(prescriptionId));
    }

    @Test
    void shouldReturnEmptyListOnMissingPrescriptionId() {
        PrescriptionId prescriptionId = PrescriptionId.from((String)"160.000.000.000.000.10");
        String fileName = "Bundle-SearchSetMultipleMedicationDispenseBundle.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.4.0/medicationdispensebundle/Bundle-SearchSetMultipleMedicationDispenseBundle.json");
        ErxMedicationDispenseBundle bundle = (ErxMedicationDispenseBundle)parser.decode(ErxMedicationDispenseBundle.class, content);
        List l1 = (List)Assertions.assertDoesNotThrow(() -> bundle.getDispensePairBy(prescriptionId));
        Assertions.assertTrue((boolean)l1.isEmpty());
        List l2 = (List)Assertions.assertDoesNotThrow(() -> bundle.unpackDispensePairBy(prescriptionId));
        Assertions.assertTrue((boolean)l2.isEmpty());
    }
}

