/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.valueset.ConsentScope;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxConsent;
import de.gematik.test.erezept.fhir.r4.erp.ErxConsentBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.valuesets.ConsentType;
import java.util.List;
import org.hl7.fhir.r4.model.Consent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxConsentTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH_1_1_1 = "fhir/valid/erp/1.1.1/";
    private static final String BASE_PATH_1_2_0 = "fhir/valid/erp/1.2.0/consent/";

    ErxConsentTest() {
    }

    @Test
    void shouldEncodeSingleConsent() {
        String fileName = "Consent_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Consent_01.xml");
        ErxConsent consent = (ErxConsent)parser.decode(ErxConsent.class, content);
        Assertions.assertNotNull((Object)consent, (String)"Valid ErxConsent must be parseable");
        Assertions.assertEquals((Object)Consent.ConsentState.ACTIVE, (Object)consent.getStatus());
        Assertions.assertEquals((Object)ConsentType.CHARGCONS, (Object)consent.getConsentType());
        Assertions.assertEquals((Object)ConsentScope.PATIENT_PRIVACY, (Object)consent.getConsentScope());
        Assertions.assertEquals((Object)"X123456789", (Object)consent.getPatientKvid());
    }

    @Test
    void shouldThrowOnMissingConsentType() {
        String fileName = "Consent_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Consent_01.xml");
        ErxConsent consent = (ErxConsent)parser.decode(ErxConsent.class, content);
        Assertions.assertNotNull((Object)consent, (String)"Valid ErxConsent must be parseable");
        consent.setCategory(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxConsent)consent).getConsentType());
    }

    @Test
    void shouldThrowInvalidConsentTypeSystems() {
        String fileName = "Consent_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/Consent_01.xml");
        ErxConsent consent = (ErxConsent)parser.decode(ErxConsent.class, content);
        Assertions.assertNotNull((Object)consent, (String)"Valid ErxConsent must be parseable");
        consent.getCategory().forEach(category -> category.getCoding().forEach(coding -> {
            String s = coding.getSystem();
            coding.setSystem(s.replace("https://gematik.de", "https://abc.de"));
        }));
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxConsent)consent).getConsentType());
    }

    @Test
    void shouldGetConsentTypes() {
        String fileName = "bundle_6daaade4-6523-4136-94bf-cbc5a247cc7b.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/consent/bundle_6daaade4-6523-4136-94bf-cbc5a247cc7b.json");
        ErxConsentBundle consentBundle = (ErxConsentBundle)parser.decode(ErxConsentBundle.class, content);
        Assertions.assertNotNull((Object)consentBundle, (String)"Valid ErxConsentBundle must be parseable");
        Assertions.assertTrue((boolean)consentBundle.getConsent().isPresent());
        ErxConsent consent = (ErxConsent)consentBundle.getConsent().orElseThrow();
        Assertions.assertEquals((Object)Consent.ConsentState.ACTIVE, (Object)consent.getStatus());
        Assertions.assertEquals((Object)ConsentType.CHARGCONS, (Object)consent.getConsentType());
        Assertions.assertEquals((Object)ConsentScope.PATIENT_PRIVACY, (Object)consent.getConsentScope());
        Assertions.assertEquals((Object)"X110465770", (Object)consent.getPatientKvid());
    }
}

