/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxConsent;
import de.gematik.test.erezept.fhir.r4.erp.ErxConsentBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxConsentBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/1.2.0/consent/";

    ErxConsentBundleTest() {
    }

    @Test
    void shouldEncodeSingleConsentBundle() {
        String fileName = "bundle_6daaade4-6523-4136-94bf-cbc5a247cc7b.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/consent/bundle_6daaade4-6523-4136-94bf-cbc5a247cc7b.json");
        ErxConsentBundle consentBundle = (ErxConsentBundle)parser.decode(ErxConsentBundle.class, content);
        Assertions.assertNotNull((Object)consentBundle, (String)"Valid ErxConsentBundle must be parseable");
        Assertions.assertTrue((boolean)consentBundle.hasConsent());
        Assertions.assertTrue((boolean)consentBundle.getConsent().isPresent());
        ErxConsent consent = (ErxConsent)consentBundle.getConsent().orElseThrow();
        Assertions.assertEquals((Object)"CHARGCONS-X110465770", (Object)consent.getConsentId());
    }
}

