/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.r4.erp.ChargeItemCommunicationType;
import de.gematik.test.erezept.fhir.r4.erp.CommunicationType;
import de.gematik.test.erezept.fhir.r4.erp.ErxCommunication;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.TaskId;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxCommunicationTest
extends ErpFhirParsingTest {
    private final String BASE_PATH_111 = "fhir/valid/erp/1.1.1/";
    private final String BASE_PATH_120 = "fhir/valid/erp/1.2.0/";

    ErxCommunicationTest() {
    }

    @Test
    void shouldEncodeSingleCommunicationDispReq() {
        List.of("CommunicationDispReq_01.xml", "CommunicationDispReq_01.json").forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            ErxCommunication communication = (ErxCommunication)parser.decode(ErxCommunication.class, content);
            Assertions.assertNotNull((Object)communication, (String)"Valid ErxCommunicationDispReq must be parseable");
            TaskId expectedTaskId = TaskId.from((String)"4711");
            AccessCode expectedAccessCode = new AccessCode("777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea");
            String expectedSenderKvid = "X234567890";
            String expectedRecipientId = "606358757";
            String expectedMessage = "Bitte schicken Sie einen Boten.";
            Communication.CommunicationStatus expectedStatus = Communication.CommunicationStatus.UNKNOWN;
            LocalDateTime expectedDate = ZonedDateTime.parse("2020-03-12T18:01:10+00:00").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            Assertions.assertFalse((boolean)communication.hasAboutReference());
            Assertions.assertFalse((boolean)communication.getAboutReference().isPresent());
            Assertions.assertEquals((Object)CommunicationType.DISP_REQ, (Object)communication.getType());
            Assertions.assertEquals((Object)expectedTaskId, (Object)communication.getBasedOnReferenceId());
            Assertions.assertTrue((boolean)communication.getBasedOnAccessCode().isPresent());
            Assertions.assertEquals((Object)expectedAccessCode, communication.getBasedOnAccessCode().orElseThrow());
            Assertions.assertEquals((Object)"X234567890", (Object)communication.getSenderId());
            Assertions.assertEquals((Object)"606358757", (Object)communication.getRecipientId());
            Assertions.assertEquals((Object)"Bitte schicken Sie einen Boten.", (Object)communication.getMessage());
            Assertions.assertEquals((Object)expectedStatus, (Object)communication.getStatus());
            Assertions.assertEquals((Object)expectedDate, (Object)communication.getSentDate());
        });
    }

    @Test
    void shouldEncodeSingleCommunicationInfoReq() {
        List.of("CommunicationInfoReq_01.xml", "CommunicationInfoReq_01.json").forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            ErxCommunication communication = (ErxCommunication)parser.decode(ErxCommunication.class, content);
            Assertions.assertNotNull((Object)communication, (String)"Valid ErxCommunicationInfoReq must be parseable");
            TaskId expectedTaskId = TaskId.from((String)"4711");
            String expectedAboutRef = "#5fe6e06c-8725-46d5-aecd-e65e041ca3de";
            String expectedSenderKvid = "X234567890";
            String expectedRecipientId = "606358757";
            String expectedMessage = "Hallo, ich wollte gern fragen, ob das Medikament bei Ihnen vorraetig ist.";
            Communication.CommunicationStatus expectedStatus = Communication.CommunicationStatus.UNKNOWN;
            LocalDateTime expectedDate = ZonedDateTime.parse("2020-03-12T18:01:10+00:00").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            Assertions.assertEquals((Object)CommunicationType.INFO_REQ, (Object)communication.getType());
            Assertions.assertEquals((Object)expectedTaskId, (Object)communication.getBasedOnReferenceId());
            Assertions.assertTrue((boolean)communication.hasAboutReference());
            Assertions.assertEquals((Object)"#5fe6e06c-8725-46d5-aecd-e65e041ca3de", communication.getAboutReference().orElseThrow());
            Assertions.assertEquals((Object)"X234567890", (Object)communication.getSenderId());
            Assertions.assertEquals((Object)"606358757", (Object)communication.getRecipientId());
            Assertions.assertEquals((Object)"Hallo, ich wollte gern fragen, ob das Medikament bei Ihnen vorraetig ist.", (Object)communication.getMessage());
            Assertions.assertEquals((Object)expectedStatus, (Object)communication.getStatus());
            Assertions.assertEquals((Object)expectedDate, (Object)communication.getSentDate());
            Assertions.assertTrue((boolean)communication.isSubstitutionAllowed());
        });
    }

    @Test
    void shouldEncodeSingleCommunicationReply() {
        List.of("CommunicationReply_01.xml", "CommunicationReply_01.json").forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            ErxCommunication communication = (ErxCommunication)parser.decode(ErxCommunication.class, content);
            Assertions.assertNotNull((Object)communication, (String)"Valid ErxCommunicationInfoReq must be parseable");
            TaskId expectedTaskId = TaskId.from((String)"4711");
            String expectedRecipientKvid = "X234567890";
            String expectedSenderId = "606358757";
            String expectedMessage = "Hallo, wir haben das Medikament vorr\u00e4tig. Kommen Sie gern in die Filiale oder wir schicken einen Boten.";
            Communication.CommunicationStatus expectedStatus = Communication.CommunicationStatus.UNKNOWN;
            LocalDateTime expectedDate = ZonedDateTime.parse("2020-03-12T18:01:10+00:00").toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            Assertions.assertEquals((Object)CommunicationType.REPLY, (Object)communication.getType());
            Assertions.assertFalse((boolean)communication.hasAboutReference());
            Assertions.assertFalse((boolean)communication.getAboutReference().isPresent());
            Assertions.assertEquals((Object)expectedTaskId, (Object)communication.getBasedOnReferenceId());
            Assertions.assertEquals((Object)"X234567890", (Object)communication.getRecipientId());
            Assertions.assertEquals((Object)"606358757", (Object)communication.getSenderId());
            Assertions.assertEquals((Object)"Hallo, wir haben das Medikament vorr\u00e4tig. Kommen Sie gern in die Filiale oder wir schicken einen Boten.", (Object)communication.getMessage());
            Assertions.assertEquals((Object)expectedStatus, (Object)communication.getStatus());
            Assertions.assertEquals((Object)expectedDate, (Object)communication.getSentDate());
        });
    }

    @Test
    void shouldMatchChargeItemBasedOn() {
        ErxCommunication com = new ErxCommunication();
        TaskId taskId = TaskId.from((String)"200.000.001.205.914.41");
        String acValue = "796a39e35bab3cb9c9ea44a80703bb4953ec7411d010a984a447108194d9b576";
        String referenceValue = MessageFormat.format("ChargeItem/{0}?ac={1}", taskId, "796a39e35bab3cb9c9ea44a80703bb4953ec7411d010a984a447108194d9b576");
        Reference reference = new Reference(referenceValue);
        com.setBasedOn(List.of(reference));
        Assertions.assertTrue((boolean)com.getBasedOnAccessCode().isPresent());
        Assertions.assertEquals((Object)AccessCode.fromString((String)"796a39e35bab3cb9c9ea44a80703bb4953ec7411d010a984a447108194d9b576"), com.getBasedOnAccessCode().orElseThrow());
        Assertions.assertFalse((boolean)com.getBasedOnReferenceId().getValue().isEmpty());
        Assertions.assertEquals((Object)taskId, (Object)com.getBasedOnReferenceId());
    }

    @Test
    void shouldMatchBasedOnReference() {
        List.of("a218a36e-f2fd-4603-ba67-c827acfef01b.json", "a218a36e-f2fd-4603-ba67-c827acfef01b.xml").forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)MessageFormat.format("{0}communication/{1}", "fhir/valid/erp/1.2.0/", fileName));
            ErxCommunication communication = (ErxCommunication)parser.decode(ErxCommunication.class, content);
            Assertions.assertEquals((Object)"777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea", communication.getBasedOnAccessCodeString().orElseThrow());
            Assertions.assertEquals((Object)TaskId.from((String)"160.000.033.491.280.78"), (Object)communication.getBasedOnReferenceId());
        });
    }

    @Test
    void shouldDecodeWithoutExpectedType() {
        List.of("CommunicationReply_01.xml", "CommunicationReply_01.json").forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            Resource communication = parser.decode(content);
            Assertions.assertEquals((Object)ResourceType.Communication, (Object)communication.getResourceType());
            Assertions.assertEquals(ErxCommunication.class, communication.getClass());
        });
    }

    @Test
    void shouldReadSearchSetBundleCorrectly() {
        List.of("CommunicationSearchBundle.json", "CommunicationSearchBundle.xml").forEach(fileName -> {
            String bundleContent = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            Bundle bundle = (Bundle)parser.decode(Bundle.class, bundleContent);
            Bundle.BundleEntryComponent firstEntry = (Bundle.BundleEntryComponent)bundle.getEntry().get(0);
            Resource patt10028$temp = firstEntry.getResource();
            if (patt10028$temp instanceof ErxCommunication) {
                ErxCommunication com = (ErxCommunication)patt10028$temp;
                Assertions.assertEquals((Object)"89e0747c0360a1a25c267bd69b37a51ab930cefa95d80277b58ed28cb0d822de", com.getBasedOnAccessCodeString().orElseThrow());
                Assertions.assertEquals((Object)TaskId.from((String)"160.000.006.306.676.73"), (Object)com.getBasedOnReferenceId());
            } else {
                Assertions.fail((String)MessageFormat.format("First Entry must be of type {0} but was {1}", ErxCommunication.class, firstEntry.getResource().getResourceType()));
            }
        });
    }

    @Test
    void shouldProvideKvidNamingSystemFromType01() {
        List<CommunicationType> kvidReceiving = List.of(CommunicationType.REPLY, CommunicationType.REPRESENTATIVE);
        kvidReceiving.forEach(type -> Assertions.assertEquals((Object)DeBasisProfilNamingSystem.KVID, (Object)type.getRecipientNamingSystem(ErpWorkflowVersion.V1_1_1)));
    }

    @Test
    void shouldProvideKvidNamingSystemFromType02() {
        List<ChargeItemCommunicationType> kvidReceiving = List.of(ChargeItemCommunicationType.CHANGE_REPLY);
        kvidReceiving.forEach(type -> Assertions.assertEquals((Object)DeBasisProfilNamingSystem.KVID_PKV_SID, (Object)type.getRecipientNamingSystem(ErpWorkflowVersion.getDefaultVersion())));
    }

    @Test
    void shouldProvidePharmacyNamingSystemFromType01() {
        List<CommunicationType> kvidReceiving = List.of(CommunicationType.INFO_REQ, CommunicationType.DISP_REQ);
        kvidReceiving.forEach(type -> Assertions.assertEquals((Object)ErpWorkflowNamingSystem.TELEMATIK_ID, (Object)type.getRecipientNamingSystem(ErpWorkflowVersion.V1_1_1)));
    }

    @Test
    void shouldProvidePharmacyNamingSystemFromType02() {
        List<ChargeItemCommunicationType> kvidReceiving = List.of(ChargeItemCommunicationType.CHANGE_REQ);
        kvidReceiving.forEach(type -> Assertions.assertEquals((Object)ErpWorkflowNamingSystem.TELEMATIK_ID_SID, (Object)type.getRecipientNamingSystem(ErpWorkflowVersion.getDefaultVersion())));
    }
}

