/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.CommunicationType;
import de.gematik.test.erezept.fhir.r4.erp.ErxCommunication;
import de.gematik.test.erezept.fhir.r4.erp.ErxCommunicationBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxCommunicationBundleTest
extends ErpFhirParsingTest {
    private final String BASE_PATH = "fhir/valid/erp/1.1.1/";

    ErxCommunicationBundleTest() {
    }

    @Test
    void shouldEncodeSingleCommunicationBundle() {
        String fileName = "CommunicationReplyBundle_01.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/CommunicationReplyBundle_01.json");
        ErxCommunicationBundle communicationBundle = (ErxCommunicationBundle)parser.decode(ErxCommunicationBundle.class, content);
        Assertions.assertNotNull((Object)communicationBundle, (String)"Valid ErxCommunicationBundle must be parseable");
        Assertions.assertEquals((int)1, (int)communicationBundle.getCommunications().size());
        ErxCommunication com = (ErxCommunication)communicationBundle.getCommunications().get(0);
        Assertions.assertEquals((Object)CommunicationType.REPLY, (Object)com.getType());
        Assertions.assertEquals((int)1, (int)communicationBundle.getCommunicationsFromSender("606358757").size());
        Assertions.assertEquals((int)1, (int)communicationBundle.getCommunicationsForReceiver("X234567890").size());
    }
}

