/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.dav.DavPkvAbgabedatenFaker;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemBuilder;
import de.gematik.test.erezept.fhir.builder.erp.ErxChargeItemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpBundleFaker;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.ErpWorkflowStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.PatientenrechnungStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.version.PatientenrechnungVersion;
import de.gematik.test.erezept.fhir.r4.dav.AbgabedatensatzReference;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.erp.ErxChargeItem;
import de.gematik.test.erezept.fhir.r4.erp.ErxReceipt;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AccessCode;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.mockito.Mockito;

class ErxChargeItemTest
extends ErpFhirParsingTest {
    private final String BASE_PATH = "fhir/valid/erp/1.1.1/";
    private final String BASE_PATH_120 = "fhir/valid/erp/1.2.0/";

    ErxChargeItemTest() {
    }

    @Test
    void shouldEncodeValidErxChargeItems() {
        List<String> rawFiles = List.of("ChargeItem_01.xml", "ChargeItem_01.json");
        rawFiles.forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            ErxChargeItem chargeItem = (ErxChargeItem)parser.decode(ErxChargeItem.class, content);
            Assertions.assertNotNull((Object)chargeItem, (String)"Valid ErxMedicationDispense must be parseable");
            Assertions.assertFalse((boolean)chargeItem.hasInsuranceProvider());
            Assertions.assertFalse((boolean)chargeItem.hasSubsidy());
            Assertions.assertFalse((boolean)chargeItem.hasTaxOffice());
            Assertions.assertEquals((Object)"160.123.456.789.123.58", (Object)chargeItem.getPrescriptionId().getValue());
            Assertions.assertEquals((Object)ChargeItem.ChargeItemStatus.BILLABLE, (Object)chargeItem.getStatus());
            Assertions.assertEquals((Object)"X234567890", (Object)chargeItem.getSubjectKvnr().getValue());
            Assertions.assertEquals((Object)"606358757", (Object)chargeItem.getEntererTelematikId().getValue());
            Assertions.assertFalse((boolean)chargeItem.isFromNewProfiles());
        });
    }

    @Test
    void shouldEncodeValidErxChargeItemsAsResource() {
        List<String> rawFiles = List.of("ChargeItem_01.xml", "ChargeItem_01.json");
        rawFiles.forEach(fileName -> {
            String content = ResourceLoader.readFileFromResource((String)("fhir/valid/erp/1.1.1/" + fileName));
            Resource chargeItem = parser.decode(content);
            Assertions.assertNotNull((Object)chargeItem, (String)"Valid ChargeItem must be parseable");
            Assertions.assertEquals((Object)ResourceType.ChargeItem, (Object)chargeItem.getResourceType());
            Assertions.assertEquals(ErxChargeItem.class, chargeItem.getClass());
        });
    }

    @Test
    @SetSystemProperty(key="erp.fhir.profile", value="1.2.0")
    void shouldFindNewProfilePrescriptionId() {
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/ChargeItem_01.xml");
        ErxChargeItem chargeItem = (ErxChargeItem)parser.decode(ErxChargeItem.class, content);
        chargeItem.getIdentifier().stream().filter(xva$0 -> ErpWorkflowNamingSystem.PRESCRIPTION_ID.matches(new Identifier[]{xva$0})).forEach(identifier -> identifier.setSystem(ErpWorkflowNamingSystem.PRESCRIPTION_ID_121.getCanonicalUrl()));
        Assertions.assertEquals((Object)new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID_121, "160.123.456.789.123.58"), (Object)chargeItem.getPrescriptionId());
    }

    @Test
    void shouldThrowOnMissingFields() {
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/ChargeItem_01.xml");
        ErxChargeItem chargeItem = (ErxChargeItem)parser.decode(ErxChargeItem.class, content);
        chargeItem.setIdentifier(List.of());
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxChargeItem)chargeItem).getPrescriptionId());
        Assertions.assertTrue((boolean)chargeItem.getAccessCode().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#erpFhirProfileVersions"})
    @ClearSystemProperty(key="erp.fhir.profile")
    void shouldChangeContainedData(String erpFhirProfileVersion) {
        System.setProperty("erp.fhir.profile", erpFhirProfileVersion);
        PrescriptionId prescriptionId = PrescriptionId.random();
        DavPkvAbgabedatenBundle davBundle = DavPkvAbgabedatenFaker.builder((PrescriptionId)prescriptionId).fake();
        KbvErpBundle kbvBundle = KbvErpBundleFaker.builder().fake();
        ErxReceipt erxReceipt = (ErxReceipt)Mockito.mock(ErxReceipt.class);
        Mockito.when((Object)erxReceipt.getId()).thenReturn((Object)"Bundle/12345");
        ErxChargeItem chargeItem = ErxChargeItemBuilder.forPrescription((PrescriptionId)prescriptionId).version(PatientenrechnungVersion.V1_0_0).accessCode((String)AccessCode.random().getValue()).status("billable").enterer("606358757").subject(KVNR.from((String)"X234567890"), GemFaker.insuranceName()).receipt(erxReceipt).markingFlag(false, false, true).verordnung(kbvBundle).abgabedatensatz(davBundle, b -> "helloworld".getBytes()).build();
        String changedResource = "changed binary data";
        AbgabedatensatzReference abgabeReference = new AbgabedatensatzReference(UUID.randomUUID().toString());
        ErxChargeItem changedChargeItem = chargeItem.withChangedContainedBinaryData(abgabeReference, "changed binary data".getBytes());
        Assertions.assertEquals((Object)"changed binary data", (Object)new String(changedChargeItem.getContainedBinaryData()));
        ValidationResult vr = ValidatorUtil.encodeAndValidate(parser, (Resource)changedChargeItem);
        Assertions.assertTrue((boolean)vr.isSuccessful());
    }

    @Test
    void shouldFindNewProfileMarkingFlags() {
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/ChargeItem_01.xml");
        ErxChargeItem chargeItem = (ErxChargeItem)parser.decode(ErxChargeItem.class, content);
        chargeItem.getExtension().stream().filter(ext -> ext.getUrl().equals(ErpWorkflowStructDef.MARKING_FLAG.getCanonicalUrl())).forEach(identifier -> identifier.setUrl(PatientenrechnungStructDef.MARKING_FLAG.getCanonicalUrl()));
        Assertions.assertFalse((boolean)chargeItem.hasInsuranceProvider());
        Assertions.assertFalse((boolean)chargeItem.hasSubsidy());
        Assertions.assertFalse((boolean)chargeItem.hasTaxOffice());
    }

    @Test
    void shouldThrowOnMissingMarkingFlags() {
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/ChargeItem_01.xml");
        ErxChargeItem chargeItem = (ErxChargeItem)parser.decode(ErxChargeItem.class, content);
        Extension markingFlagExtension = chargeItem.getExtension().stream().filter(ext -> ext.getUrl().equals(ErpWorkflowStructDef.MARKING_FLAG.getCanonicalUrl()) || ext.getUrl().equals(PatientenrechnungStructDef.MARKING_FLAG.getCanonicalUrl())).findFirst().orElseThrow();
        chargeItem.getExtension().remove(markingFlagExtension);
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxChargeItem)chargeItem).hasTaxOffice());
    }

    @Test
    void generateChargeItem() {
        ErxChargeItem chargeItem = this.generateWithAccessCodeByFaker("AccessTestCode123456");
        ValidationResult res = ValidatorUtil.encodeAndValidate(parser, (Resource)chargeItem);
        Assertions.assertTrue((boolean)res.isSuccessful());
        Assertions.assertTrue((boolean)((String)((AccessCode)chargeItem.getAccessCode().orElseThrow()).getValue()).contains("AccessTestCode123456"));
    }

    @Test
    void checkForAccessCodeShouldWork() {
        ErxChargeItem chargeItem = this.generateWithAccessCodeByFaker("AccessTestCode123456");
        Assertions.assertTrue((boolean)chargeItem.getAccessCode().isPresent());
    }

    private ErxChargeItem generateWithAccessCodeByFaker(String code) {
        return ErxChargeItemFaker.builder().withPrescriptionId(new PrescriptionId("testIdForChargeItem123456789")).withAccessCode(code).fake();
    }
}

