/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxChargeItemBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.AccessCode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxChargeItemBundleTest
extends ErpFhirParsingTest {
    private final String BASE_PATH_VALID = "fhir/valid/erp/1.2.0/chargeitembundle/";

    ErxChargeItemBundleTest() {
    }

    @Test
    void getChargeItemAsPharmacy() {
        String fileName = "ea33a992-a214-11ed-a8fc-0242ac120002.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/chargeitembundle/ea33a992-a214-11ed-a8fc-0242ac120002.xml");
        ErxChargeItemBundle bundle = (ErxChargeItemBundle)parser.decode(ErxChargeItemBundle.class, content);
        Assertions.assertNotNull((Object)bundle, (String)"Valid ErxTaskBundle must be parseable");
        Assertions.assertNotNull((Object)bundle.getChargeItem());
        Assertions.assertEquals((Object)"200.086.824.605.539.20", (Object)bundle.getChargeItem().getPrescriptionId().getValue());
        Assertions.assertTrue((boolean)bundle.getChargeItem().getAccessCode().isEmpty());
        Assertions.assertDoesNotThrow(() -> ((ErxChargeItemBundle)bundle).getAbgabedatenBundle());
    }

    @Test
    void getChargeItemAsPatient() {
        String fileName = "abc825bc-bc30-45f8-b109-1b343fff5c45.json";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/chargeitembundle/abc825bc-bc30-45f8-b109-1b343fff5c45.json");
        ErxChargeItemBundle bundle = (ErxChargeItemBundle)parser.decode(ErxChargeItemBundle.class, content);
        Assertions.assertNotNull((Object)bundle, (String)"Valid ErxTaskBundle must be parseable");
        Assertions.assertNotNull((Object)bundle.getChargeItem());
        Assertions.assertEquals((Object)"200.086.824.605.539.20", (Object)bundle.getChargeItem().getPrescriptionId().getValue());
        Assertions.assertEquals((Object)"777bea0e13cc9c42ceec14aec3ddee2263325dc2c6c699db115f58fe423607ea", (Object)((AccessCode)bundle.getChargeItem().getAccessCode().orElseThrow()).getValue());
        Assertions.assertEquals((Object)"Bundle/dffbfd6a-5712-4798-bdc8-07201eb77ab8", bundle.getChargeItem().getReceiptReference().orElseThrow());
        Assertions.assertTrue((boolean)bundle.getReceipt().isPresent());
    }

    @Test
    void shouldThrowException() {
        String fileName = "InValidBundle_40057350-a305-11ed-a8fc-0242ac120002.xml";
        String basePathInvalid = "fhir/invalid/erp/1.2.0/chargeitembundle/";
        String content = ResourceLoader.readFileFromResource((String)"fhir/invalid/erp/1.2.0/chargeitembundle/InValidBundle_40057350-a305-11ed-a8fc-0242ac120002.xml");
        ErxChargeItemBundle bundle = (ErxChargeItemBundle)parser.decode(ErxChargeItemBundle.class, content);
        Assertions.assertThrows(MissingFieldException.class, () -> ((ErxChargeItemBundle)bundle).getChargeItem());
    }
}

