/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxAuditEventBundle;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class ErxBundleTest
extends ErpFhirParsingTest {
    private static final String VALID_BUNDLE_PATH = "fhir/valid/erp/1.2.0/auditeventbundle/2d4ba5fa-d0ff-4b59-b1c4-8849bd83a971.json";
    private static final String INVALID_BUNDLE_PATH = "fhir/invalid/erp/AuditEventBundle.json";
    private static ErxAuditEventBundle erxAuditEventBundle;
    private static ErxAuditEventBundle invaliErxAuditEventBundle;

    ErxBundleTest() {
    }

    @BeforeAll
    static void prepare() {
        erxAuditEventBundle = (ErxAuditEventBundle)parser.decode(ErxAuditEventBundle.class, ResourceLoader.readFileFromResource((String)VALID_BUNDLE_PATH));
        invaliErxAuditEventBundle = (ErxAuditEventBundle)parser.decode(ErxAuditEventBundle.class, ResourceLoader.readFileFromResource((String)INVALID_BUNDLE_PATH));
    }

    @Test
    void shouldDetectNextRelation() {
        Assertions.assertTrue((boolean)erxAuditEventBundle.hasNextRelation());
    }

    @Test
    void shouldDetectPreviousRelation() {
        Assertions.assertTrue((boolean)erxAuditEventBundle.hasPreviousRelation());
    }

    @Test
    void shouldDetectFirstRelation() {
        Assertions.assertTrue((boolean)erxAuditEventBundle.hasFirstRelation());
    }

    @Test
    void shouldDetectLastRelation() {
        Assertions.assertTrue((boolean)erxAuditEventBundle.hasLastRelation());
    }

    @Test
    void shouldDetectSelfRelation() {
        Assertions.assertTrue((boolean)erxAuditEventBundle.hasSelfRelation());
    }

    @Test
    void shouldDetectNoNextRelation() {
        Assertions.assertFalse((boolean)invaliErxAuditEventBundle.hasNextRelation());
    }

    @Test
    void shouldDetectNoPreviousRelation() {
        Assertions.assertFalse((boolean)invaliErxAuditEventBundle.hasPreviousRelation());
    }

    @Test
    void shouldDetectNoFirstRelation() {
        Assertions.assertFalse((boolean)invaliErxAuditEventBundle.hasFirstRelation());
    }

    @Test
    void shouldDetectNoLastRelation() {
        Assertions.assertFalse((boolean)invaliErxAuditEventBundle.hasLastRelation());
    }

    @Test
    void shouldDetectNoSelfRelation() {
        Assertions.assertFalse((boolean)invaliErxAuditEventBundle.hasSelfRelation());
    }
}

