/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.r4.erp.ErxAuditEvent;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.text.MessageFormat;
import java.util.Arrays;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxAuditEventTest
extends ErpFhirParsingTest {
    private final String BASE_PATH = "fhir/valid/erp/1.1.1/";

    ErxAuditEventTest() {
    }

    @Test
    void representationTextDoesNotThrow() {
        Arrays.stream(ErxAuditEvent.Representation.values()).forEach(r -> Assertions.assertDoesNotThrow(() -> ((ErxAuditEvent.Representation)r).getText()));
    }

    @Test
    void shouldEncodeSingleAuditEvent() {
        String fileName = "AuditEvent_01.json";
        EncodingType originalEncoding = EncodingType.JSON;
        EncodingType flippedEncoding = originalEncoding.flipEncoding();
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/AuditEvent_01.json");
        ErxAuditEvent auditEvent = (ErxAuditEvent)parser.decode(ErxAuditEvent.class, content);
        Assertions.assertDoesNotThrow(() -> ((ErxAuditEvent)auditEvent).toString());
        Assertions.assertNotNull((Object)auditEvent, (String)"Valid ErxAuditEvent must be parseable");
        AuditEvent.AuditEventAction expectedAction = AuditEvent.AuditEventAction.fromCode((String)"C");
        Assertions.assertEquals((Object)expectedAction, (Object)auditEvent.getAction());
        String expectedIdentifierValue = "606358750";
        String expectedIdentifierSystem = ErpWorkflowNamingSystem.TELEMATIK_ID.getCanonicalUrl();
        String expectedPrescriptionId = "160.123.456.789.123.58";
        Assertions.assertEquals((Object)"606358750", (Object)auditEvent.getAgentFirstRep().getWho().getIdentifier().getValue());
        Assertions.assertEquals((Object)expectedIdentifierSystem, (Object)auditEvent.getAgentFirstRep().getWho().getIdentifier().getSystem());
        Assertions.assertTrue((boolean)auditEvent.getPrescriptionId().isPresent());
        Assertions.assertEquals((Object)"160.123.456.789.123.58", (Object)((PrescriptionId)auditEvent.getPrescriptionId().orElseThrow()).getValue());
        String flippedContent = parser.encode((IBaseResource)auditEvent, flippedEncoding);
        ErxAuditEvent flippedAuditEvent = (ErxAuditEvent)parser.decode(ErxAuditEvent.class, flippedContent);
        Assertions.assertEquals((Object)auditEvent.getAction(), (Object)flippedAuditEvent.getAction());
        Assertions.assertEquals((Object)auditEvent.getAgentFirstRep().getWho().getIdentifier().getValue(), (Object)flippedAuditEvent.getAgentFirstRep().getWho().getIdentifier().getValue());
        Assertions.assertEquals((Object)auditEvent.getAgentFirstRep().getWho().getIdentifier().getSystem(), (Object)flippedAuditEvent.getAgentFirstRep().getWho().getIdentifier().getSystem());
        Assertions.assertEquals((Object)"Sample Text", (Object)auditEvent.getFirstText());
        Assertions.assertEquals((Object)"606358750", (Object)auditEvent.getAgentId());
        Assertions.assertEquals((Object)"Praxis Dr. M\u00fcller", (Object)auditEvent.getAgentName());
    }

    @Test
    void shouldDecodeAuditEventWithoutProfile() {
        String fileName = "AuditEventBundle.json";
        String content = ResourceLoader.readFileFromResource((String)MessageFormat.format("fhir/invalid/erp/{0}", "AuditEventBundle.json"));
        Resource bundle = parser.decode(content);
        Assertions.assertEquals((Object)ResourceType.Bundle, (Object)bundle.getResourceType());
    }
}

