/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.erp;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.erp.ErxAcceptBundle;
import de.gematik.test.erezept.fhir.r4.erp.ErxTask;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.TaskId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ErxAcceptBundleTest
extends ErpFhirParsingTest {
    private static final String BASE_PATH = "fhir/valid/erp/";
    private static final String BASE_PATH_1_1_1 = "fhir/valid/erp/1.1.1/";
    private static final String BASE_PATH_1_2_0 = "fhir/valid/erp/1.2.0/acceptbundle/";

    ErxAcceptBundleTest() {
    }

    @Test
    void shouldEncodeSingleAcceptBundle() {
        String fileName = "TaskAcceptBundle_01.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/TaskAcceptBundle_01.xml");
        ErxAcceptBundle acceptBundle = (ErxAcceptBundle)parser.decode(ErxAcceptBundle.class, content);
        Assertions.assertNotNull((Object)acceptBundle, (String)"Valid ErxAcceptBundle must be parseable");
        TaskId expectedTaskId = TaskId.from((String)"a4c72c7d-1ee3-11b2-825b-c505a820f066");
        ErxTask erxTask = acceptBundle.getTask();
        Assertions.assertEquals((Object)expectedTaskId, (Object)erxTask.getTaskId());
        Assertions.assertEquals((Object)expectedTaskId, (Object)acceptBundle.getTaskId());
        String expectedKbvBundleId = "a54bfb25-1ee3-11b2-825c-c505a820f066";
        Assertions.assertEquals((Object)"a54bfb25-1ee3-11b2-825c-c505a820f066", (Object)acceptBundle.getKbvBundleId());
        Assertions.assertTrue((acceptBundle.getSignedKbvBundle().length > 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldEncodeSingleAcceptBundle120() {
        String fileName = "cef4b960-7ce4-4755-b4ce-3b01a30ec2f0.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.2.0/acceptbundle/cef4b960-7ce4-4755-b4ce-3b01a30ec2f0.xml");
        ErxAcceptBundle acceptBundle = (ErxAcceptBundle)parser.decode(ErxAcceptBundle.class, content);
        Assertions.assertNotNull((Object)acceptBundle, (String)"Valid ErxAcceptBundle must be parseable");
        String expectedTaskId = "160.000.031.325.758.69";
        ErxTask erxTask = acceptBundle.getTask();
        Assertions.assertEquals((Object)"160.000.031.325.758.69", (Object)erxTask.getTaskId().getValue());
        String expectedKbvBundleId = "a03efedd-0100-0000-0001-000000000000";
        Assertions.assertEquals((Object)"a03efedd-0100-0000-0001-000000000000", (Object)acceptBundle.getKbvBundleId());
        Assertions.assertEquals((Object)"e2715cb0d512591a0c8dece2178b2998c38ea7bfb78b4cd5f805096cbd809f26", (Object)acceptBundle.getSecret().getValue());
    }

    @Test
    void shouldEncodeSingleAcceptBundleWithConsent() {
        String fileName = "TaskAcceptBundle_02.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/erp/1.1.1/TaskAcceptBundle_02.xml");
        ErxAcceptBundle acceptBundle = (ErxAcceptBundle)parser.decode(ErxAcceptBundle.class, content);
        Assertions.assertNotNull((Object)acceptBundle, (String)"Valid ErxAcceptBundle must be parseable");
        Assertions.assertTrue((boolean)acceptBundle.hasConsent());
    }
}

