/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.dav;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.r4.dav.DavInvoice;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvDispensedMedication;
import de.gematik.test.erezept.fhir.r4.dav.PharmacyOrganization;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.sql.Date;
import java.time.LocalDate;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DavPkvAbgabedatenBundleTest
extends ErpFhirParsingTest {
    private final String BASE_PATH = "fhir/valid/dav/";

    DavPkvAbgabedatenBundleTest() {
    }

    @Test
    void testEncodeSingleValidBundle() {
        String expectedID = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2";
        PrescriptionId expectedPrescriptionId = new PrescriptionId("200.100.000.000.081.90");
        PrescriptionFlowType expectedFlowType = PrescriptionFlowType.FLOW_TYPE_200;
        String fileName = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/dav/ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml");
        DavPkvAbgabedatenBundle bundle = (DavPkvAbgabedatenBundle)parser.decode(DavPkvAbgabedatenBundle.class, content);
        Assertions.assertEquals((Object)"ad80703d-8c62-44a3-b12b-2ea66eda0aa2", (Object)bundle.getLogicalId());
        Assertions.assertEquals((Object)expectedPrescriptionId, (Object)bundle.getPrescriptionId());
        Assertions.assertNotNull((Object)bundle.getDescription());
        PharmacyOrganization pharm = bundle.getPharmacy();
        Assertions.assertNotNull((Object)pharm);
        Assertions.assertEquals((Object)"Adler-Apotheke", (Object)pharm.getName());
        DavPkvDispensedMedication dispensed = bundle.getDispensedMedication();
        Assertions.assertNotNull((Object)dispensed);
        Assertions.assertEquals((Object)expectedPrescriptionId, (Object)dispensed.getPrescriptionId());
        Assertions.assertEquals((Object)expectedFlowType, (Object)bundle.getFlowType());
        Assertions.assertEquals((Object)"urn:uuid:5dc67a4f-c936-4c26-a7c0-967673a70740", (Object)dispensed.getPerformerReference());
        Assertions.assertEquals((Object)MedicationDispense.MedicationDispenseStatus.COMPLETED, (Object)dispensed.getStatus());
        Assertions.assertEquals((Object)Date.valueOf(LocalDate.of(2023, 7, 24)), (Object)dispensed.getWhenHandedOver());
        DavInvoice invoice = bundle.getInvoice();
        Assertions.assertNotNull((Object)invoice);
        Assertions.assertEquals((Object)Invoice.InvoiceStatus.ISSUED, (Object)invoice.getStatus());
        Assertions.assertEquals((Object)"06313728", (Object)invoice.getPzn());
        Assertions.assertEquals((double)30.33, (double)invoice.getTotalPrice(), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)invoice.getTotalCoPayment(), (double)0.001);
        Assertions.assertEquals((Object)"EUR", (Object)invoice.getCurrency());
        Assertions.assertEquals((double)19.0, (double)invoice.getVAT(), (double)0.001);
    }

    @Test
    void shouldDecodeWithoutExpectedType() {
        String expectedID = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2";
        String fileName = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/dav/ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml");
        Resource bundle = parser.decode(content);
        Assertions.assertEquals((Object)ResourceType.Bundle, (Object)bundle.getResourceType());
        Assertions.assertEquals(DavPkvAbgabedatenBundle.class, bundle.getClass());
    }

    @Test
    void shouldCastFromResource() {
        String expectedID = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2";
        String fileName = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml";
        String content = ResourceLoader.readFileFromResource((String)"fhir/valid/dav/ad80703d-8c62-44a3-b12b-2ea66eda0aa2.xml");
        Resource bundleResource = parser.decode(content);
        Assertions.assertDoesNotThrow(() -> DavPkvAbgabedatenBundle.fromBundle((Resource)bundleResource));
    }
}

