/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.r4.dav;

import de.gematik.test.erezept.fhir.parser.profiles.definitions.AbdaErpPkvStructDef;
import de.gematik.test.erezept.fhir.r4.dav.AbgabedatensatzReference;
import java.text.MessageFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AbgabedatensatzReferenceTest {
    AbgabedatensatzReferenceTest() {
    }

    @Test
    void shouldHaveNonContainedId() {
        String id = "123";
        AbgabedatensatzReference ref = new AbgabedatensatzReference("123");
        Assertions.assertEquals((Object)"123", (Object)ref.getReference());
        Assertions.assertEquals((Object)AbdaErpPkvStructDef.PKV_ABGABEDATENSATZ.getCanonicalUrl(), (Object)ref.getType());
    }

    @Test
    void shouldHaveContainedId() {
        String id = "123";
        AbgabedatensatzReference ref = new AbgabedatensatzReference("123");
        ref.makeContained();
        Assertions.assertEquals((Object)MessageFormat.format("#{0}", "123"), (Object)ref.getReference());
        Assertions.assertEquals((Object)"Binary", (Object)ref.getType());
    }

    @Test
    void shouldGetNonContainedId() {
        String id = "123";
        AbgabedatensatzReference ref = new AbgabedatensatzReference("123");
        ref.makeContained();
        Assertions.assertEquals((Object)"123", (Object)ref.getReference(false));
        Assertions.assertEquals((Object)"Binary", (Object)ref.getType());
    }

    @Test
    void shouldGetContainedId() {
        String id = "123";
        AbgabedatensatzReference ref = new AbgabedatensatzReference("123");
        ref.makeContained();
        Assertions.assertEquals((Object)MessageFormat.format("#{0}", "123"), (Object)ref.getReference(true));
        Assertions.assertEquals((Object)"Binary", (Object)ref.getType());
    }
}

