/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser.profiles.version;

import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.testutil.ErpFhirBuildingTest;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class KbvItaForVersionTest
extends ErpFhirBuildingTest {
    KbvItaForVersionTest() {
    }

    @Test
    void getDefaultVersionViaCurrentDate() {
        KbvItaForVersion defaultVersion = KbvItaForVersion.getDefaultVersion();
        Assertions.assertEquals((Object)KbvItaForVersion.V1_1_0, (Object)defaultVersion);
    }

    @ParameterizedTest
    @MethodSource
    @ClearSystemProperty(key="kbv.ita.for")
    void getDefaultVersionViaSystemProperty(KbvItaForVersion version) {
        System.setProperty("kbv.ita.for", version.getVersion());
        KbvItaForVersion defaultVersion = KbvItaForVersion.getDefaultVersion();
        Assertions.assertEquals((Object)version, (Object)defaultVersion);
    }

    static Stream<Arguments> getDefaultVersionViaSystemProperty() {
        return Arrays.stream(KbvItaForVersion.values()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

