/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser.profiles.version;

import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.testutil.ErpFhirBuildingTest;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.ClearSystemProperty;

class KbvItaErpVersionTest
extends ErpFhirBuildingTest {
    KbvItaErpVersionTest() {
    }

    @Test
    void getDefaultVersionViaCurrentDate() {
        KbvItaErpVersion defaultVersion = KbvItaErpVersion.getDefaultVersion();
        Assertions.assertEquals((Object)KbvItaErpVersion.V1_1_0, (Object)defaultVersion);
    }

    @Test
    @ClearSystemProperty(key="kbv.ita.erp")
    void getDefaultVersionViaSystemProperty() {
        Arrays.stream(KbvItaErpVersion.values()).forEach(version -> {
            System.setProperty("kbv.ita.erp", version.getVersion());
            KbvItaErpVersion defaultVersion = KbvItaErpVersion.getDefaultVersion();
            Assertions.assertEquals((Object)version, (Object)defaultVersion);
        });
    }
}

