/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser.profiles.version;

import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpBasisVersion;
import de.gematik.test.erezept.fhir.testutil.ErpFhirBuildingTest;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class AbdaErpBasisVersionTest
extends ErpFhirBuildingTest {
    AbdaErpBasisVersionTest() {
    }

    @ParameterizedTest
    @MethodSource
    @ClearSystemProperty(key="de.abda.erezeptabgabedatenbasis")
    void getDefaultVersionViaSystemProperty(AbdaErpBasisVersion version) {
        System.setProperty("de.abda.erezeptabgabedatenbasis", version.getVersion());
        AbdaErpBasisVersion defaultVersion = AbdaErpBasisVersion.getDefaultVersion();
        Assertions.assertEquals((Object)version, (Object)defaultVersion);
    }

    static Stream<Arguments> getDefaultVersionViaSystemProperty() {
        return Arrays.stream(AbdaErpBasisVersion.values()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @Test
    void shouldCompareVersions() {
        Assertions.assertEquals((int)1, (int)AbdaErpBasisVersion.V1_3_1.compareTo((Enum)AbdaErpBasisVersion.V1_2_1));
        Assertions.assertEquals((int)0, (int)AbdaErpBasisVersion.V1_2_1.compareTo((Enum)AbdaErpBasisVersion.V1_2_1));
        Assertions.assertEquals((int)0, (int)AbdaErpBasisVersion.V1_3_1.compareTo((Enum)AbdaErpBasisVersion.V1_3_1));
        Assertions.assertEquals((int)-1, (int)AbdaErpBasisVersion.V1_2_1.compareTo((Enum)AbdaErpBasisVersion.V1_3_1));
    }
}

