/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser;

import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.FhirParser;
import de.gematik.test.erezept.fhir.parser.ValidatorMode;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidatorTest
extends ErpFhirParsingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatorTest.class);

    ValidatorTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldPassValidResources(File file) {
        ValidatorUtil.validateFile(parser, file, Assertions::assertTrue, true);
    }

    static Stream<Arguments> shouldPassValidResources() {
        return ResourceLoader.getResourceDirectoryStructure((String)"fhir/valid", (boolean)true).stream().filter(File::isFile).filter(file -> !file.getAbsolutePath().contains("erp/1.1.1")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldDetectInvalidResources(File invalidResource) {
        ValidatorUtil.validateFile(parser, invalidResource, Assertions::assertFalse, false);
    }

    static Stream<Arguments> shouldDetectInvalidResources() {
        return ResourceLoader.getResourceDirectoryStructure((String)"fhir/invalid", (boolean)true).stream().filter(File::isFile).map(xva$0 -> Arguments.arguments((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest(name="Validate Mixed Version Bundles with {0}")
    @EnumSource(value=ValidatorMode.class, names={"PEDANTIC", "STRICT"})
    @ClearSystemProperty(key="erp.fhir.validator.mode")
    @Disabled(value="Validator-Mode not yet implemented")
    void shouldValidateMixedVersionBundlesWithStrictPedanticValidation(ValidatorMode mode) {
        System.setProperty("erp.fhir.validator.mode", mode.name());
        FhirParser pedanticFhir = new FhirParser();
        List mixedBundleResources = ResourceLoader.getResourceDirectoryStructure((String)"fhir/valid/mixed_bundles", (boolean)true);
        ValidatorUtil.validateFiles(pedanticFhir, mixedBundleResources, Assertions::assertTrue, false);
    }
}

