/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import de.gematik.bbriccs.fhir.conf.exceptions.FhirConfigurationException;
import de.gematik.test.erezept.fhir.parser.ValidatorMode;
import java.util.List;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.mockito.Mockito;

class ValidatorModeTest {
    ValidatorModeTest() {
    }

    private SingleValidationMessage createMessage(ResultSeverityEnum severity, String message) {
        SingleValidationMessage svm = new SingleValidationMessage();
        svm.setSeverity(severity);
        svm.setMessage(message);
        return svm;
    }

    private void assertAmountOf(ValidationResult result, ResultSeverityEnum severity, int num) {
        List<SingleValidationMessage> filtered = result.getMessages().stream().filter(svm -> svm.getSeverity().equals((Object)severity)).toList();
        Assertions.assertEquals((int)num, (int)filtered.size());
    }

    @Test
    void shouldDoNothingOnNormalMode() {
        FhirContext ctx = (FhirContext)Mockito.mock(FhirContext.class);
        List<SingleValidationMessage> messages = List.of(this.createMessage(ResultSeverityEnum.INFORMATION, "info"), this.createMessage(ResultSeverityEnum.WARNING, "warning"), this.createMessage(ResultSeverityEnum.ERROR, "error"));
        ValidationResult vr = new ValidationResult(ctx, messages);
        Assertions.assertFalse((boolean)vr.isSuccessful());
        ValidationResult adjusted = ValidatorMode.NORMAL.adjustResult(vr);
        Assertions.assertEquals((Object)vr, (Object)adjusted);
        this.assertAmountOf(adjusted, ResultSeverityEnum.INFORMATION, 1);
        this.assertAmountOf(adjusted, ResultSeverityEnum.WARNING, 1);
        this.assertAmountOf(adjusted, ResultSeverityEnum.ERROR, 1);
        this.assertAmountOf(adjusted, ResultSeverityEnum.FATAL, 0);
    }

    @Test
    void shouldLiftOnStrict() {
        FhirContext ctx = (FhirContext)Mockito.mock(FhirContext.class);
        List<SingleValidationMessage> messages = List.of(this.createMessage(ResultSeverityEnum.INFORMATION, "info"), this.createMessage(ResultSeverityEnum.WARNING, "warning"), this.createMessage(ResultSeverityEnum.ERROR, "error"), this.createMessage(ResultSeverityEnum.FATAL, "fatal"));
        ValidationResult vr = new ValidationResult(ctx, messages);
        Assertions.assertFalse((boolean)vr.isSuccessful());
        ValidationResult adjusted = ValidatorMode.STRICT.adjustResult(vr);
        Assertions.assertNotEquals((Object)vr, (Object)adjusted);
        Assertions.assertFalse((boolean)adjusted.isSuccessful());
        this.assertAmountOf(adjusted, ResultSeverityEnum.INFORMATION, 0);
        this.assertAmountOf(adjusted, ResultSeverityEnum.WARNING, 1);
        this.assertAmountOf(adjusted, ResultSeverityEnum.ERROR, 2);
        this.assertAmountOf(adjusted, ResultSeverityEnum.FATAL, 1);
    }

    @Test
    void shouldLiftOnPedantic() {
        FhirContext ctx = (FhirContext)Mockito.mock(FhirContext.class);
        List<SingleValidationMessage> messages = List.of(this.createMessage(ResultSeverityEnum.INFORMATION, "info"), this.createMessage(ResultSeverityEnum.WARNING, "warning"), this.createMessage(ResultSeverityEnum.ERROR, "error"), this.createMessage(ResultSeverityEnum.FATAL, "fatal"));
        ValidationResult vr = new ValidationResult(ctx, messages);
        Assertions.assertFalse((boolean)vr.isSuccessful());
        ValidationResult adjusted = ValidatorMode.PEDANTIC.adjustResult(vr);
        Assertions.assertNotEquals((Object)vr, (Object)adjusted);
        Assertions.assertFalse((boolean)adjusted.isSuccessful());
        this.assertAmountOf(adjusted, ResultSeverityEnum.INFORMATION, 0);
        this.assertAmountOf(adjusted, ResultSeverityEnum.WARNING, 0);
        this.assertAmountOf(adjusted, ResultSeverityEnum.ERROR, 3);
        this.assertAmountOf(adjusted, ResultSeverityEnum.FATAL, 1);
    }

    @Test
    @ClearSystemProperty(key="erp.fhir.validator.mode")
    void shouldThrowOnInvalidValidatorModeConfiguration() {
        System.setProperty("erp.fhir.validator.mode", "hello");
        Assertions.assertThrows(FhirConfigurationException.class, ValidatorMode::getDefault);
    }

    @Test
    void shouldThrowOnInvalidNameValue() {
        ObjectMapper om = new ObjectMapper();
        String input = "{\"mode\": \"hello\"}";
        ValueInstantiationException ex = (ValueInstantiationException)Assertions.assertThrows(ValueInstantiationException.class, () -> om.readValue("{\"mode\": \"hello\"}", MockValidatorConfig.class));
        Assertions.assertEquals(FhirConfigurationException.class, ex.getCause().getClass());
    }

    @Test
    void shouldGetNormalModeOnDefault() {
        ValidatorMode mode = ValidatorMode.getDefault();
        Assertions.assertEquals((Object)ValidatorMode.NORMAL, (Object)mode);
    }

    @Test
    @ClearSystemProperty(key="erp.fhir.validator.mode")
    void shouldGetNormalModeOnEmptyConfiguration() {
        System.setProperty("erp.fhir.validator.mode", "");
        ValidatorMode mode = ValidatorMode.getDefault();
        Assertions.assertEquals((Object)ValidatorMode.NORMAL, (Object)mode);
    }

    private static class MockValidatorConfig {
        private ValidatorMode mode;

        @Generated
        public MockValidatorConfig() {
        }

        @Generated
        public ValidatorMode getMode() {
            return this.mode;
        }

        @Generated
        public void setMode(ValidatorMode mode) {
            this.mode = mode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockValidatorConfig)) {
                return false;
            }
            MockValidatorConfig other = (MockValidatorConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ValidatorMode this$mode = this.getMode();
            ValidatorMode other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MockValidatorConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ValidatorMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ValidatorModeTest.MockValidatorConfig(mode=" + String.valueOf(this.getMode()) + ")";
        }
    }
}

