/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.parser;

import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.profiles.definitions.KbvItaErpStructDef;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.r4.dav.DavPkvAbgabedatenBundle;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpBundle;
import de.gematik.test.erezept.fhir.testutil.EncodingUtil;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.RegExUtil;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParserTest
extends ErpFhirParsingTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParserTest.class);

    ParserTest() {
    }

    @Test
    void shouldParseOfficialOldKbvBundleResources() {
        List kbvBundleResources = ResourceLoader.getResourceFilesInDirectory((String)"fhir/valid/kbv/1.0.2/bundle");
        kbvBundleResources.forEach(file -> {
            log.trace("Parse KBV Bundle {}", (Object)file.getName());
            String content = ResourceLoader.readString((File)file);
            KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
            Assertions.assertNotNull((Object)kbvBundle);
            PrescriptionId expectedPrescriptionId = new PrescriptionId(ErpWorkflowNamingSystem.PRESCRIPTION_ID, RegExUtil.getPrescriptionId(content).orElseThrow());
            String id = file.getName().split("\\.")[0];
            String bundleMetaProfile = kbvBundle.getFullMetaProfile();
            String bundleMetaProfileVersion = kbvBundle.getMetaProfileVersion();
            String prescriptionNamingSystem = kbvBundle.getIdentifier().getSystem();
            List entries = kbvBundle.getEntry();
            Assertions.assertEquals((Object)id, (Object)kbvBundle.getLogicalId());
            Assertions.assertTrue((boolean)KbvItaErpStructDef.BUNDLE.matches(bundleMetaProfile));
            Assertions.assertEquals((Object)"1.0.2", (Object)bundleMetaProfileVersion);
            Assertions.assertEquals((Object)ErpWorkflowNamingSystem.PRESCRIPTION_ID.getCanonicalUrl(), (Object)prescriptionNamingSystem);
            Assertions.assertEquals((Object)expectedPrescriptionId, (Object)kbvBundle.getPrescriptionId());
            Assertions.assertFalse((boolean)entries.isEmpty());
        });
    }

    @Test
    void shouldParseOfficialNewKbvBundleResources() {
        List kbvBundleResources = ResourceLoader.getResourceFilesInDirectory((String)"fhir/valid/kbv/1.1.0/bundle");
        kbvBundleResources.forEach(file -> {
            log.trace("Parse KBV Bundle {}", (Object)file.getName());
            String content = ResourceLoader.readString((File)file);
            KbvErpBundle kbvBundle = (KbvErpBundle)parser.decode(KbvErpBundle.class, content);
            Assertions.assertNotNull((Object)kbvBundle);
            PrescriptionId expectedPrescriptionId = new PrescriptionId(RegExUtil.getPrescriptionIdFor121(content).orElseThrow());
            String id = file.getName().split("\\.")[0];
            String bundleMetaProfile = kbvBundle.getFullMetaProfile();
            String bundleMetaProfileVersion = kbvBundle.getMetaProfileVersion();
            ErpWorkflowNamingSystem prescriptionNamingSystem = (ErpWorkflowNamingSystem)kbvBundle.getPrescriptionId().getSystem();
            List entries = kbvBundle.getEntry();
            Assertions.assertEquals((Object)id, (Object)kbvBundle.getLogicalId());
            Assertions.assertTrue((boolean)KbvItaErpStructDef.BUNDLE.matches(bundleMetaProfile));
            Assertions.assertEquals((Object)"1.1.0", (Object)bundleMetaProfileVersion);
            Assertions.assertEquals((Object)ErpWorkflowNamingSystem.PRESCRIPTION_ID_121, (Object)prescriptionNamingSystem);
            Assertions.assertEquals((Object)expectedPrescriptionId, (Object)kbvBundle.getPrescriptionId());
            Assertions.assertFalse((boolean)entries.isEmpty());
        });
    }

    @Test
    void shouldParseResourceWithoutExpectedClass() {
        String id = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String content = ResourceLoader.readFileFromResource((String)MessageFormat.format("fhir/valid/kbv/1.0.2/bundle/{0}.xml", "1f339db0-9e55-4946-9dfa-f1b30953be9b"));
        Resource r1 = parser.decode(content, EncodingType.XML);
        Assertions.assertTrue((boolean)r1.getId().contains("1f339db0-9e55-4946-9dfa-f1b30953be9b"));
        Resource r2 = parser.decode(content);
        Assertions.assertTrue((boolean)r2.getId().contains("1f339db0-9e55-4946-9dfa-f1b30953be9b"));
    }

    @Test
    void shouldGetConcreteDavTypeFromTypeHints() {
        String id = "ad80703d-8c62-44a3-b12b-2ea66eda0aa2";
        List.of(EncodingType.XML, EncodingType.JSON).forEach(encoding -> {
            String content = ResourceLoader.readFileFromResource((String)MessageFormat.format("fhir/valid/dav/{0}.{1}", "ad80703d-8c62-44a3-b12b-2ea66eda0aa2", encoding.toFileExtension()));
            Resource resource = parser.decode(content);
            Assertions.assertTrue((boolean)resource.getId().contains("ad80703d-8c62-44a3-b12b-2ea66eda0aa2"));
            Assertions.assertEquals(DavPkvAbgabedatenBundle.class, resource.getClass());
        });
    }

    @Test
    void shouldGetConcreteKbvTypeFromTypeHints() {
        String id = "1f339db0-9e55-4946-9dfa-f1b30953be9b";
        String content = ResourceLoader.readFileFromResource((String)MessageFormat.format("fhir/valid/kbv/1.0.2/bundle/{0}.xml", "1f339db0-9e55-4946-9dfa-f1b30953be9b"));
        Resource resource = parser.decode(content);
        Assertions.assertTrue((boolean)resource.getId().contains("1f339db0-9e55-4946-9dfa-f1b30953be9b"));
        Assertions.assertEquals(KbvErpBundle.class, resource.getClass());
        String contentJson = EncodingUtil.reEncode(parser, resource, EncodingType.JSON);
        Resource resource2 = parser.decode(contentJson);
        Assertions.assertTrue((boolean)resource.getId().contains("1f339db0-9e55-4946-9dfa-f1b30953be9b"));
        Assertions.assertEquals(KbvErpBundle.class, resource2.getClass());
    }
}

