/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.extensions.kbv;

import de.gematik.test.erezept.fhir.extensions.kbv.MultiplePrescriptionExtension;
import de.gematik.test.erezept.fhir.extensions.kbv.MultiplePrescriptionIdExtension;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.testutil.ErpFhirBuildingTest;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Ratio;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MultiplePrescriptionExtensionTest
extends ErpFhirBuildingTest {
    MultiplePrescriptionExtensionTest() {
    }

    @Test
    void shouldCreateNonMultiple() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asNonMultiple();
        Extension ext = mvo.asExtension();
        Extension kennzeichen = ext.getExtensionByUrl("Kennzeichen");
        Boolean isMvo = (Boolean)kennzeichen.getValueAsPrimitive().getValue();
        Assertions.assertFalse((boolean)isMvo);
    }

    @Test
    void shouldCreateIndefinitelyMultiple() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withoutEndDate();
        Extension ext = mvo.asExtension();
        Extension kennzeichen = ext.getExtensionByUrl("Kennzeichen");
        Boolean isMvo = (Boolean)kennzeichen.getValueAsPrimitive().getValue();
        Assertions.assertTrue((boolean)isMvo);
        Extension nummerierung = ext.getExtensionByUrl("Nummerierung");
        Ratio ratio = nummerierung.getValue().castToRatio((Base)nummerierung.getValue());
        Assertions.assertEquals((Object)new BigDecimal(1), (Object)ratio.getNumerator().getValue());
        Assertions.assertEquals((Object)new BigDecimal(4), (Object)ratio.getDenominator().getValue());
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
    }

    @Test
    void shouldBuildCorrectValuePeriod() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).fromNow().validForDays(30);
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Assertions.assertNotNull((Object)period.getStartElement().getValue());
        Assertions.assertNotNull((Object)period.getEndElement().getValue());
    }

    @Test
    void shouldBuildCorrectValuePeriodWithoutAutoStart() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validForDays(30, false);
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Assertions.assertNull((Object)period.getStartElement().getValue());
        Assertions.assertNotNull((Object)period.getEndElement().getValue());
    }

    @Test
    void shouldBuildWithStartDaysDiff() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).starting(10).withoutEndDate();
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Date startDate = (Date)period.getStartElement().getValue();
        Assertions.assertNotNull((Object)startDate);
        Calendar cal = Calendar.getInstance();
        cal.add(5, 10);
        Date expected = cal.getTime();
        long diff = expected.getTime() - startDate.getTime();
        Assertions.assertTrue((diff < 1000L ? 1 : 0) != 0);
    }

    @Test
    void shouldBuildWithValidThrough() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).validThrough(10, 30);
        Assertions.assertTrue((boolean)mvo.isMultiple());
        Assertions.assertTrue((boolean)mvo.getStart().isPresent());
        Assertions.assertTrue((boolean)mvo.getEnd().isPresent());
        Date start = (Date)mvo.getStart().orElseThrow();
        Date end = (Date)mvo.getEnd().orElseThrow();
        Assertions.assertTrue((boolean)end.after(start));
    }

    @Test
    void shouldBuildPeriodWithoutEnd() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).fromNow().withoutEndDate();
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Assertions.assertNotNull((Object)period.getStartElement().getValue());
        Assertions.assertNull((Object)period.getEndElement().getValue());
    }

    @Test
    void shouldBuildPeriodWithoutEndDateAndAutoStart() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withoutEndDate();
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Assertions.assertNotNull((Object)period.getStartElement().getValue());
        Assertions.assertNull((Object)period.getEndElement().getValue());
    }

    @Test
    void shouldBuildPeriodWithoutEndDateAndWithoutAutoStart() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withoutEndDate(false);
        Extension ext = mvo.asExtension();
        Extension zeitraum = ext.getExtensionByUrl("Zeitraum");
        Assertions.assertNotNull((Object)zeitraum);
        Period period = zeitraum.getValue().castToPeriod((Base)zeitraum.getValue());
        Assertions.assertNull((Object)period.getStartElement().getValue());
        Assertions.assertNull((Object)period.getEndElement().getValue());
    }

    @Test
    void shouldCreateWithId() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withId(MultiplePrescriptionIdExtension.invalidId()).withoutEndDate(false);
        Extension ext = mvo.asExtension(KbvItaErpVersion.V1_1_0);
        Extension idExt = ext.getExtensionByUrl("ID");
        String mvoId = idExt.getValue().castToIdentifier((Base)idExt.getValue()).getValue();
        Assertions.assertTrue((boolean)mvoId.contains("13061707"));
    }

    @Test
    void shouldIgnoreIdOnOldProfiles() {
        MultiplePrescriptionExtension mvo = MultiplePrescriptionExtension.asMultiple((int)1, (int)4).withId(MultiplePrescriptionIdExtension.invalidId()).withoutEndDate(false);
        Extension ext = mvo.asExtension(KbvItaErpVersion.V1_0_2);
        Extension idExt = ext.getExtensionByUrl("ID");
        Assertions.assertNull((Object)idExt);
    }
}

