/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.extensions.kbv;

import de.gematik.bbriccs.fhir.coding.exceptions.MissingFieldException;
import de.gematik.test.erezept.fhir.extensions.kbv.AccidentExtension;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.ClearSystemProperty;

class AccidentExtensionTest {
    AccidentExtensionTest() {
    }

    private static Stream<Arguments> kbvBundleVersions() {
        return Stream.of(Arguments.of((Object[])new Object[]{KbvItaErpVersion.V1_0_2}), Arguments.of((Object[])new Object[]{KbvItaErpVersion.V1_1_0}));
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldBuildAccidentExtension(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        AccidentExtension ae = AccidentExtension.accident();
        Extension outer = ae.asExtension();
        Optional<Extension> kennzeichen = outer.getExtension().stream().filter(e -> e.getUrl().equalsIgnoreCase("unfallkennzeichen")).findAny();
        Assertions.assertTrue((boolean)kennzeichen.isPresent());
        Optional<Extension> unfalltag = outer.getExtension().stream().filter(e -> e.getUrl().equalsIgnoreCase("unfalltag")).findAny();
        Assertions.assertTrue((boolean)unfalltag.isPresent());
        Assertions.assertTrue((boolean)ae.toString().contains(ae.accidentCauseType().getDisplay()));
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldBuildAccidentExtensionWithFaker(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        for (int i = 0; i < 5; ++i) {
            AccidentExtension ae = AccidentExtension.faker();
            Extension outer = ae.asExtension();
            Optional<Extension> kennzeichen = outer.getExtension().stream().filter(e -> e.getUrl().equalsIgnoreCase("unfallkennzeichen")).findAny();
            Assertions.assertTrue((boolean)kennzeichen.isPresent());
        }
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldEqualAccidents(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        Date date = new Date();
        AccidentExtension ae1 = AccidentExtension.accident((Date)date);
        AccidentExtension ae2 = AccidentExtension.accident((Date)date);
        Assertions.assertEquals((Object)ae1, (Object)ae2);
        Assertions.assertEquals((int)ae1.hashCode(), (int)ae2.hashCode());
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldNotEqualOnDifferentAccidentDates(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        AccidentExtension ae1 = AccidentExtension.accident((Date)new Date());
        AccidentExtension ae2 = AccidentExtension.accident((Date)cal.getTime());
        Assertions.assertNotEquals((Object)ae1, (Object)ae2);
        Assertions.assertNotEquals((int)ae1.hashCode(), (int)ae2.hashCode());
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldEqualAccidentsAtWork(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        Date date = new Date();
        AccidentExtension ae1 = AccidentExtension.accidentAtWork((Date)date).atWorkplace("Arbeitsplatz");
        AccidentExtension ae2 = AccidentExtension.accidentAtWork((Date)date).atWorkplace("Arbeitsplatz");
        Assertions.assertEquals((Object)ae1, (Object)ae2);
        Assertions.assertEquals((int)ae1.hashCode(), (int)ae2.hashCode());
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldNotEqualAccidentsAtWorkOnDifferentWorkplaces(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        Date date = new Date();
        AccidentExtension ae1 = AccidentExtension.accidentAtWork((Date)date).atWorkplace("Arbeitsplatz");
        AccidentExtension ae2 = AccidentExtension.accidentAtWork((Date)date).atWorkplace("B\u00fcro");
        Assertions.assertNotEquals((Object)ae1, (Object)ae2);
        Assertions.assertNotEquals((int)ae1.hashCode(), (int)ae2.hashCode());
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldEqualAccidentsOccupationalDiseases(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        AccidentExtension ae1 = AccidentExtension.occupationalDisease();
        AccidentExtension ae2 = AccidentExtension.occupationalDisease();
        Assertions.assertEquals((Object)ae1, (Object)ae2);
        Assertions.assertEquals((int)ae1.hashCode(), (int)ae2.hashCode());
    }

    @ParameterizedTest(name="[{index}] -> AccidentExtension in versions KbvItaErpVersion {0}")
    @MethodSource(value={"kbvBundleVersions"})
    @ClearSystemProperty(key="kbv.ita.erp")
    void shouldNotEqualOnDifferentCauses(KbvItaErpVersion kbvItaErpVersion) {
        System.setProperty(kbvItaErpVersion.getName(), kbvItaErpVersion.getVersion());
        AccidentExtension ae1 = AccidentExtension.accident();
        AccidentExtension ae2 = AccidentExtension.accidentAtWork().atWorkplace();
        AccidentExtension ae3 = AccidentExtension.occupationalDisease();
        Assertions.assertNotEquals((Object)ae1, (Object)ae2);
        Assertions.assertNotEquals((Object)ae1, (Object)ae3);
        Assertions.assertNotEquals((Object)ae2, (Object)ae3);
    }

    @Test
    void shouldThrowOnInvalidExtension() {
        Extension extension = new Extension();
        extension.addExtension(new Extension("Testkennzeichen"));
        Assertions.assertThrows(MissingFieldException.class, () -> AccidentExtension.fromExtension((Extension)extension));
    }

    @Test
    void shouldEqualOnSameObject() {
        AccidentExtension ae;
        AccidentExtension ae2 = ae = AccidentExtension.accident();
        Assertions.assertEquals((Object)ae, (Object)ae2);
    }

    @Test
    void shouldNotEqualOnOtherType() {
        AccidentExtension ae = AccidentExtension.accident();
        Assertions.assertNotEquals(null, (Object)ae);
        Assertions.assertNotEquals((Object)"Hello World", (Object)ae);
    }
}

