/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.extensions.erp;

import de.gematik.test.erezept.fhir.extensions.erp.SupplyOptionsType;
import de.gematik.test.erezept.fhir.testutil.ErpFhirBuildingTest;
import org.hl7.fhir.r4.model.Extension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class SupplyOptionsTypeTest
extends ErpFhirBuildingTest {
    SupplyOptionsTypeTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"onPremise", "onpremise", "ONPREMISE", "nix "})
    void onPremiseShouldWorkCorrect(String supplyType) {
        Assertions.assertEquals((Object)SupplyOptionsType.ON_PREMISE, (Object)SupplyOptionsType.getSupplyOptionType((String)supplyType));
    }

    @ParameterizedTest
    @CsvSource(value={"delivery", "DELIVERY", "deLiVery"})
    void deliveryShouldWorkCorrect(String supplyType) {
        Assertions.assertEquals((Object)SupplyOptionsType.DELIVERY, (Object)SupplyOptionsType.getSupplyOptionType((String)supplyType));
    }

    @ParameterizedTest
    @CsvSource(value={"shipment", "Shipment", "SHIPMent"})
    void shipmentShouldWorkCorrect(String supplyType) {
        Assertions.assertEquals((Object)SupplyOptionsType.SHIPMENT, (Object)SupplyOptionsType.getSupplyOptionType((String)supplyType));
    }

    @Test
    void shouldGetSupplyOptionsAsExtensionWithDefaultVersion() {
        SupplyOptionsType sot = SupplyOptionsType.createDefault();
        Extension ext = sot.asExtension();
        Assertions.assertNotNull((Object)ext);
    }
}

