/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.date;

import de.gematik.test.erezept.fhir.date.DateConverter;
import de.gematik.test.erezept.fhir.date.WeekendRule;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WeekendRuleTest {
    WeekendRuleTest() {
    }

    @Test
    void shouldDetectWeekends() {
        WeekendRule rule = WeekendRule.forWeekends();
        for (int i = 0; i < 2; ++i) {
            Date date = new GregorianCalendar(2023, 2, 18 + i).getTime();
            Assertions.assertTrue((boolean)rule.isOn(date));
        }
    }

    @Test
    void shouldFailOnWorkingDays() {
        WeekendRule rule = WeekendRule.forWeekends();
        for (int i = 0; i < 5; ++i) {
            Date date = new GregorianCalendar(2023, 2, 13 + i).getTime();
            Assertions.assertFalse((boolean)rule.isOn(date));
        }
    }

    @Test
    void shouldNotFindWeekendBetweenWorkingWeek() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-17");
        Assertions.assertFalse((boolean)rule.isBetween(start, end));
    }

    @Test
    void shouldFindWeekendBetween() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-31");
        Assertions.assertTrue((boolean)rule.isBetween(start, end));
    }

    @Test
    void shouldGiveNextSaturday() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-18"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SATURDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveCurrentSundayAsNextAfter() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-19");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-19"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SUNDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveNextSaturdayBetween() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-19");
        Date next = rule.firstBetween(start, end);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertTrue((boolean)rule.isBetween(start, end));
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-18"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SATURDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveCurrentSundayBetween() {
        WeekendRule rule = WeekendRule.forWeekends();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-19");
        Date end = dc.dateFromIso8601("2023-03-25");
        Date next = rule.firstBetween(start, end);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertTrue((boolean)rule.isBetween(start, end));
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-19"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SUNDAY, (Object)nextLD.getDayOfWeek());
    }
}

