/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.date;

import de.gematik.test.erezept.fhir.date.DateConverter;
import de.gematik.test.erezept.fhir.date.WeekendDayRule;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WeekendDayRuleTest {
    WeekendDayRuleTest() {
    }

    @Test
    void shouldGiveNextSaturday() {
        WeekendDayRule rule = WeekendDayRule.forSaturday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-18"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SATURDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveCurrentSaturday() {
        WeekendDayRule rule = WeekendDayRule.forSaturday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-18");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-18"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SATURDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveCurrentSunday() {
        WeekendDayRule rule = WeekendDayRule.forSunday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-19");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-19"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SUNDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveNextSunday() {
        WeekendDayRule rule = WeekendDayRule.forSunday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date next = rule.firstAfter(start);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-19"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SUNDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldGiveNextSaturdayBetween() {
        WeekendDayRule rule = WeekendDayRule.forSaturday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-19");
        Date next = rule.firstBetween(start, end);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertTrue((boolean)rule.isBetween(start, end));
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-18"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SATURDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldNotGiveNextSaturdayBetweenMondayFriday() {
        WeekendDayRule rule = WeekendDayRule.forSaturday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-16");
        Date next = rule.firstBetween(start, end);
        Assertions.assertNull((Object)next);
        Assertions.assertFalse((boolean)rule.isBetween(start, end));
    }

    @Test
    void shouldGiveNextSundayBetween() {
        WeekendDayRule rule = WeekendDayRule.forSunday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-19");
        Date next = rule.firstBetween(start, end);
        LocalDate nextLD = dc.dateToLocalDate(next);
        Assertions.assertTrue((boolean)rule.isBetween(start, end));
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-03-19"), (Object)next);
        Assertions.assertEquals((Object)DayOfWeek.SUNDAY, (Object)nextLD.getDayOfWeek());
    }

    @Test
    void shouldNotGiveNextSundayBetweenMondayFriday() {
        WeekendDayRule rule = WeekendDayRule.forSunday();
        DateConverter dc = DateConverter.getInstance();
        Date start = dc.dateFromIso8601("2023-03-13");
        Date end = dc.dateFromIso8601("2023-03-16");
        Date next = rule.firstBetween(start, end);
        Assertions.assertNull((Object)next);
        Assertions.assertFalse((boolean)rule.isBetween(start, end));
    }
}

