/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.date;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.test.erezept.fhir.date.DateCalculator;
import de.gematik.test.erezept.fhir.date.PeriodDateUtil;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import org.hl7.fhir.r4.model.Period;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PeriodDateUtilTest {
    PeriodDateUtilTest() {
    }

    @Test
    void shouldNotCallConstructor() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(PeriodDateUtil.class));
    }

    @Test
    void shouldDetectValidPeriod01() {
        Period p = new Period();
        Date yesterday = Date.from(LocalDate.now().minusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC));
        Date tomorrow = Date.from(LocalDate.now().plusDays(100L).atStartOfDay().toInstant(ZoneOffset.UTC));
        p.getStartElement().setValue(yesterday);
        p.getEndElement().setValue(tomorrow);
        Assertions.assertTrue((boolean)PeriodDateUtil.isStillValid((Period)p));
    }

    @Test
    void shouldDetectValidPeriod02() {
        Period p = new Period();
        Date yesterday = Date.from(LocalDate.now().minusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC));
        p.getStartElement().setValue(yesterday);
        Assertions.assertTrue((boolean)PeriodDateUtil.isStillValid((Period)p));
    }

    @Test
    void shouldDetectValidPeriod03() {
        Period p = new Period();
        Assertions.assertFalse((boolean)PeriodDateUtil.isStillValid((Period)p));
    }

    @Test
    void shouldUpdatePeriod() {
        Period p = new Period();
        Date yesterday = Date.from(LocalDate.of(1970, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC));
        Date tomorrow = Date.from(LocalDate.of(1970, 1, 3).atStartOfDay().toInstant(ZoneOffset.UTC));
        p.setStart(yesterday);
        p.setEnd(tomorrow);
        Period p2 = PeriodDateUtil.updatePeriod((Period)p);
        Calendar start = Calendar.getInstance();
        start.setTime(p2.getStart());
        int startDay = start.get(6);
        Calendar end = Calendar.getInstance();
        end.setTime(p2.getEnd());
        int endDay = end.get(6);
        Assertions.assertEquals((int)2, (int)(endDay - startDay));
    }

    @Test
    void shouldUpdatePeriodWithoutEnd() {
        DateCalculator edc = new DateCalculator();
        Period p = new Period();
        Date yesterday = Date.from(LocalDate.of(1970, 1, 1).atStartOfDay().toInstant(ZoneOffset.UTC));
        p.setStart(yesterday);
        Period p2 = PeriodDateUtil.updatePeriod((Period)p);
        Date start = p2.getStart();
        Assertions.assertTrue((boolean)edc.isToday(start));
        Assertions.assertNull((Object)p2.getEnd());
    }

    @Test
    void shouldNotUpdateFuturePeriods() {
        DateCalculator edc = new DateCalculator();
        Period p = new Period();
        LocalDate base = LocalDate.now().plusDays(2L);
        Date tomorrow = Date.from(base.atStartOfDay().toInstant(ZoneOffset.UTC));
        Date tomorrow2 = Date.from(base.plusDays(2L).atStartOfDay().toInstant(ZoneOffset.UTC));
        p.setStart(tomorrow);
        p.setEnd(tomorrow2);
        Period p2 = PeriodDateUtil.updatePeriod((Period)p);
        Assertions.assertTrue((boolean)edc.isAfterToday(p2.getStart()));
        LocalDate nStart = p2.getStart().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Assertions.assertTrue((boolean)base.isEqual(nStart));
        Assertions.assertEquals((Object)tomorrow, (Object)p2.getStart());
        Assertions.assertEquals((Object)tomorrow2, (Object)p2.getEnd());
    }

    @Test
    void shouldUpdateNowForEmptyPeriods() {
        DateCalculator edc = new DateCalculator();
        Period p = new Period();
        Period p2 = PeriodDateUtil.updatePeriod((Period)p);
        Assertions.assertNotNull((Object)p2.getStart());
        Assertions.assertTrue((boolean)edc.isToday(p2.getStart()));
        Assertions.assertNull((Object)p2.getEnd());
    }
}

