/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.date;

import de.gematik.test.erezept.fhir.date.DateConverter;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.Month;
import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DateConverterTest {
    DateConverterTest() {
    }

    @Test
    void shouldConvertToDateFromISO8601String() {
        String isoDate = "2023-03-13";
        Date date = DateConverter.getInstance().dateFromIso8601("2023-03-13");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assertions.assertEquals((int)2023, (int)calendar.get(1));
        Assertions.assertEquals((int)2, (int)calendar.get(2));
        Assertions.assertEquals((int)13, (int)calendar.get(5));
    }

    @Test
    void shouldConvertDateToLocalDate() {
        String isoDate = "2023-03-27";
        Date date = DateConverter.getInstance().dateFromIso8601("2023-03-27");
        LocalDate localDate = DateConverter.getInstance().dateToLocalDate(date);
        Assertions.assertEquals((int)27, (int)localDate.getDayOfMonth());
        Assertions.assertEquals((Object)Month.MARCH, (Object)localDate.getMonth());
    }

    @Test
    void shouldConvertFromLocalDateToDate() {
        String isoDate = "2023-03-27";
        LocalDate localDate = DateConverter.getInstance().localDateFromIso("2023-03-27");
        Date date = DateConverter.getInstance().localDateToDate(localDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assertions.assertEquals((int)27, (int)calendar.get(5));
        Assertions.assertEquals((int)2, (int)calendar.get(2));
    }

    @Test
    void shouldConvertToLocalDateFromISO8601String() {
        String isoDate = "2023-03-13";
        LocalDate date = DateConverter.getInstance().localDateFromIso("2023-03-13");
        Assertions.assertEquals((int)2023, (int)date.getYear());
        Assertions.assertEquals((Object)Month.MARCH, (Object)date.getMonth());
        Assertions.assertEquals((int)13, (int)date.getDayOfMonth());
    }

    @Test
    void shouldSneakyThrowOnInvalidFormat() {
        DateConverter dc = DateConverter.getInstance();
        Assertions.assertThrows(ParseException.class, () -> dc.dateFromIso8601("hello world"));
    }
}

