/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.date;

import de.gematik.test.erezept.fhir.date.DateCalculator;
import de.gematik.test.erezept.fhir.date.DateConverter;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DateCalculatorTest {
    DateCalculatorTest() {
    }

    @Test
    void nowShouldBeNotBeforeToday() {
        DateCalculator edc = new DateCalculator();
        Assertions.assertFalse((boolean)edc.isBeforeToday(new Date()));
    }

    @Test
    void nowShouldBeNotAfterToday() {
        DateCalculator edc = new DateCalculator();
        Assertions.assertFalse((boolean)edc.isAfterToday(new Date()));
    }

    @Test
    void shouldHandleNullableDates() {
        DateCalculator edc = new DateCalculator();
        Date d = null;
        LocalDate ld = null;
        Assertions.assertFalse((boolean)edc.isToday(d));
        Assertions.assertFalse((boolean)edc.isToday(ld));
        Assertions.assertFalse((boolean)edc.isBeforeToday(d));
        Assertions.assertFalse((boolean)edc.isBeforeToday(ld));
        Assertions.assertFalse((boolean)edc.isAfterToday(d));
        Assertions.assertFalse((boolean)edc.isAfterToday(ld));
    }

    @Test
    void shouldEqualWithoutTime() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date now = new Date();
        Date expectation = dc.dateFromIso8601(new SimpleDateFormat("yyyy-MM-dd").format(now));
        Assertions.assertTrue((boolean)edc.equalDates(expectation, now));
    }

    @Test
    void shouldCalculateCalendarDaysAfter() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2023-03-13");
        Date expiryDate = edc.getDateAfterCalendarDays(startDate, 20);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2023-04-02"), (Object)expiryDate);
        LocalDate expiryLD = dc.dateToLocalDate(expiryDate);
        Assertions.assertEquals((int)2, (int)expiryLD.getDayOfMonth());
        Assertions.assertEquals((Object)Month.APRIL, (Object)expiryLD.getMonth());
        Assertions.assertEquals((int)2023, (int)expiryLD.getYear());
    }

    @Test
    void shouldCalculateLocalDateCalendarDaysAfter() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        LocalDate startDate = dc.localDateFromIso("2023-03-13");
        LocalDate expiryDate = edc.getDateAfterCalendarDays(startDate, 20);
        Assertions.assertEquals((Object)dc.localDateFromIso("2023-04-02"), (Object)expiryDate);
        Assertions.assertEquals((int)2, (int)expiryDate.getDayOfMonth());
        Assertions.assertEquals((Object)Month.APRIL, (Object)expiryDate.getMonth());
        Assertions.assertEquals((int)2023, (int)expiryDate.getYear());
    }

    @Test
    void shouldCalculateWorkingDaysOverWeekend() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2023-03-13");
        Date expiryDate = edc.getDateAfterWorkingDays(startDate, 7);
        LocalDate expiryLocalDate = dc.dateToLocalDate(expiryDate);
        Assertions.assertEquals((int)22, (int)expiryLocalDate.getDayOfMonth());
        Assertions.assertEquals((Object)Month.MARCH, (Object)expiryLocalDate.getMonth());
    }

    @Test
    void shouldCalculateWorkingDaysOverEaster() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2023-04-06");
        Date expiryDate = edc.getDateAfterWorkingDays(startDate, 5);
        LocalDate expiryLocalDate = dc.dateToLocalDate(expiryDate);
        Assertions.assertEquals((int)17, (int)expiryLocalDate.getDayOfMonth());
        Assertions.assertEquals((Object)Month.APRIL, (Object)expiryLocalDate.getMonth());
    }

    @Test
    void shouldCalculateWorkingDaysOverChristmas() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        LocalDate startDate = dc.localDateFromIso("2023-12-20");
        LocalDate expiryDate = edc.getDateAfterWorkingDays(startDate, 6);
        Assertions.assertEquals((int)2, (int)expiryDate.getDayOfMonth());
        Assertions.assertEquals((Object)Month.JANUARY, (Object)expiryDate.getMonth());
        Assertions.assertEquals((int)2024, (int)expiryDate.getYear());
    }

    @Test
    void shouldCalculateWorkingDaysForWholeYear() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2023-01-01");
        Date expectedDate = dc.dateFromIso8601("2024-01-02");
        Date expiryDate = edc.getDateAfterWorkingDays(startDate, 252);
        Assertions.assertEquals((Object)expectedDate, (Object)expiryDate);
    }

    @Test
    void shouldIncrementMonths() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2022-08-31");
        Date expiryDate = edc.getDateAfterMonths(startDate, 3);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2022-11-30"), (Object)expiryDate);
        LocalDate expiryLD = dc.dateToLocalDate(expiryDate);
        Assertions.assertEquals((int)30, (int)expiryLD.getDayOfMonth());
        Assertions.assertEquals((Object)Month.NOVEMBER, (Object)expiryLD.getMonth());
        Assertions.assertEquals((int)2022, (int)expiryLD.getYear());
    }

    @Test
    void shouldIncrementMonthsOverNewYear() {
        DateConverter dc = DateConverter.getInstance();
        DateCalculator edc = new DateCalculator();
        Date startDate = dc.dateFromIso8601("2022-10-31");
        Date expiryDate = edc.getDateAfterMonths(startDate, 2);
        Assertions.assertEquals((Object)dc.dateFromIso8601("2022-12-31"), (Object)expiryDate);
        LocalDate expiryLD = dc.dateToLocalDate(expiryDate);
        Assertions.assertEquals((int)31, (int)expiryLD.getDayOfMonth());
        Assertions.assertEquals((Object)Month.DECEMBER, (Object)expiryLD.getMonth());
        Assertions.assertEquals((int)2022, (int)expiryLD.getYear());
    }
}

