/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.test.erezept.fhir.builder.kbv.KbvCoverageFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvErpMedicationPZNFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.builder.kbv.SupplyRequestBuilder;
import de.gematik.test.erezept.fhir.r4.kbv.KbvCoverage;
import de.gematik.test.erezept.fhir.r4.kbv.KbvErpMedication;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import java.util.Date;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class SupplyRequestBuilderTest
extends ErpFhirParsingTest {
    private static KbvCoverage coverage;
    private static KbvErpMedication medication;
    private static KbvPractitioner practitioner;

    SupplyRequestBuilderTest() {
    }

    @BeforeAll
    static void setup() {
        coverage = KbvCoverageFaker.builder().fake();
        medication = KbvErpMedicationPZNFaker.builder().fake();
        practitioner = KbvPractitionerFaker.builder().fake();
    }

    @Test
    void shouldBuildSimpleSupplyRequest() {
        SupplyRequestBuilder builder = SupplyRequestBuilder.withCoverage((KbvCoverage)coverage).medication(medication).requester(practitioner).authoredOn(new Date());
        SupplyRequest supplyRequest = (SupplyRequest)Assertions.assertDoesNotThrow(() -> ((SupplyRequestBuilder)builder).build());
        Assertions.assertNotNull((Object)supplyRequest);
        ValidationResult resultSupplyRequest = ValidatorUtil.encodeAndValidate(parser, (Resource)supplyRequest);
        Assertions.assertTrue((boolean)resultSupplyRequest.isSuccessful());
        Assertions.assertEquals((Object)"https://fhir.kbv.de/StructureDefinition/KBV_PR_ERP_PracticeSupply|1.1.0", (Object)((CanonicalType)supplyRequest.getMeta().getProfile().get(0)).getValue());
    }

    @Test
    void shouldThrowNullPointerExcCausedByMissingRequester() {
        SupplyRequestBuilder sr = SupplyRequestBuilder.withCoverage((KbvCoverage)coverage);
        Assertions.assertThrows(BuilderException.class, () -> ((SupplyRequestBuilder)sr).build());
    }

    @Test
    void shouldThrowNullPointerExcCausedByMissingMedicationReference() {
        SupplyRequestBuilder sr = SupplyRequestBuilder.withCoverage((KbvCoverage)coverage).requester(practitioner);
        Assertions.assertThrows(BuilderException.class, () -> ((SupplyRequestBuilder)sr).build());
    }

    @Test
    void shouldThrowNullPointerExceptionCausedByEmptyCoverage() {
        SupplyRequestBuilder sr = SupplyRequestBuilder.withCoverage((KbvCoverage)new KbvCoverage()).requester(practitioner);
        Assertions.assertThrows(BuilderException.class, () -> ((SupplyRequestBuilder)sr).build());
    }

    @Test
    void authoredOnShouldWorkWithTemporalPrecision() {
        SupplyRequest supplyRequest = SupplyRequestBuilder.withCoverage((KbvCoverage)coverage).medication(KbvErpMedicationPZNFaker.builder().fake()).requester(KbvPractitionerFaker.builder().fake()).authoredOn(new Date(), TemporalPrecisionEnum.DAY).build();
        Assertions.assertNotNull((Object)supplyRequest);
        ValidationResult resultSupplyRequest = ValidatorUtil.encodeAndValidate(parser, (Resource)supplyRequest);
        Assertions.assertTrue((boolean)resultSupplyRequest.isSuccessful());
    }
}

