/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.AsvFachgruppennummer;
import de.gematik.test.erezept.fhir.values.BaseANR;
import de.gematik.test.erezept.fhir.values.LANR;
import de.gematik.test.erezept.fhir.values.ZANR;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvPractitionerFakerTest
extends ErpFhirParsingTest {
    KbvPractitionerFakerTest() {
    }

    @Test
    void buildFakerPractitionerWithName() {
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withName("Max Mustermann").fake();
        KbvPractitioner practitioner2 = KbvPractitionerFaker.builder().withName("Max", "Mustermann").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)practitioner);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)practitioner2);
        Assertions.assertEquals((Object)"Max Mustermann", (Object)practitioner.getFullName());
        Assertions.assertEquals((Object)"Max Mustermann", (Object)practitioner2.getFullName());
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void buildFakerPatientWithQualificationType() {
        QualificationType qualificationType = (QualificationType)GemFaker.randomElement((Object[])new QualificationType[]{QualificationType.DOCTOR, QualificationType.DENTIST});
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withQualificationType(qualificationType).withQualificationType("Doctor").withQualificationType(AsvFachgruppennummer.from((String)"00")).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)practitioner);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakerPractitionerWithLanr() {
        LANR lanr = LANR.random();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withLanr(lanr.getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)practitioner);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)BaseANR.ANRType.LANR, (Object)practitioner.getANR().getType());
    }

    @Test
    void buildFakerPractitionerWithZanr() {
        ZANR zanr = ZANR.random();
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withZanr(zanr.getValue()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)practitioner);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)BaseANR.ANRType.ZANR, (Object)practitioner.getANR().getType());
    }
}

