/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KbvPatientFakerTest
extends ErpFhirParsingTest {
    KbvPatientFakerTest() {
    }

    @Test
    void buildFakerPatientWithKvnrAndInsuranceType() {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), (InsuranceTypeDe)GemFaker.randomElement((Object[])new InsuranceTypeDe[]{InsuranceTypeDe.PKV, InsuranceTypeDe.GKV})).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakePatientWithBirthDate() {
        KbvPatient patient = KbvPatientFaker.builder().withBirthDate(GemFaker.fakerBirthday()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakePatientWithAddress() {
        KbvPatient patient = KbvPatientFaker.builder().withAddress(GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void buildFakePatientWithName() {
        KbvPatient patient = KbvPatientFaker.builder().withName("Max", "Mustermann").fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertEquals((Object)"Mustermann, Max", (Object)patient.getFullname());
    }
}

