/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.builder.exceptions.BuilderException;
import de.gematik.bbriccs.fhir.de.value.KVNR;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientBuilder;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPatientFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPatient;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvPatientBuilderTest
extends ErpFhirParsingTest {
    KbvPatientBuilderTest() {
    }

    @ParameterizedTest(name="[{index}] -> Build KBV GKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildGkvPatientWithFaker(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.GKV).withVersion(version).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
        InsuranceTypeDe insuranceKind = patient.getInsuranceKind();
        Assertions.assertEquals((Object)InsuranceTypeDe.GKV, (Object)insuranceKind);
        Assertions.assertTrue((boolean)patient.hasGkvKvnr());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV PKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void buildPkvPatientWithFaker(KbvItaForVersion version) {
        KbvPatient patient = KbvPatientFaker.builder().withKvnrAndInsuranceType(KVNR.random(), InsuranceTypeDe.PKV).withVersion(version).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)patient);
        Assertions.assertTrue((boolean)result.isSuccessful());
        InsuranceTypeDe insuranceKind = patient.getInsuranceKind();
        Assertions.assertEquals((Object)InsuranceTypeDe.PKV, (Object)insuranceKind);
        Assertions.assertTrue((boolean)patient.hasPkvKvnr());
    }

    @ParameterizedTest(name="[{index}] -> Build KBV PKV Patient with KbvItaForVersion {0}")
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldFailOnEmptyPatientBuilder(KbvItaForVersion version) {
        KbvPatientBuilder pb = KbvPatientBuilder.builder().version(version);
        Assertions.assertThrows(BuilderException.class, () -> ((KbvPatientBuilder)pb).build());
    }

    @Test
    void shouldThrowOnInvalidDateFormat() {
        KbvPatientBuilder builder = KbvPatientBuilder.builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.birthDate("123123", "hello"));
    }
}

