/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.builder.kbv;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.test.erezept.fhir.builder.GemFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvMedicalOrganizationFaker;
import de.gematik.test.erezept.fhir.builder.kbv.KbvPractitionerFaker;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import de.gematik.test.erezept.fhir.r4.kbv.KbvMedicalOrganization;
import de.gematik.test.erezept.fhir.r4.kbv.KbvPractitioner;
import de.gematik.test.erezept.fhir.testutil.ErpFhirParsingTest;
import de.gematik.test.erezept.fhir.testutil.ValidatorUtil;
import de.gematik.test.erezept.fhir.values.BSNR;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class KbvMedicalOrganizationFakerTest
extends ErpFhirParsingTest {
    KbvMedicalOrganizationFakerTest() {
    }

    @Test
    void builderFakerMedicalOrganizationWithName() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder().withName(GemFaker.fakerName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void builderFakerMedicalOrganizationWithBsnr() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder().withBsnr(GemFaker.fakerBsnr()).fake();
        KbvMedicalOrganization organization2 = KbvMedicalOrganizationFaker.builder().withBsnr(BSNR.random()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        ValidationResult result2 = ValidatorUtil.encodeAndValidate(parser, (Resource)organization2);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    void shouldFakeHospitalMedicalOrganizationWithIknr() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.hospital().fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.IKNR_SID.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
    }

    @Test
    void shouldFakeHospitalMedicalOrganizationWithKsn() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder((KbvMedicalOrganizationFaker.OrganizationFakerType)KbvMedicalOrganizationFaker.OrganizationFakerType.HOSPITAL_KSN).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.STANDORTNUMMER.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
    }

    @ParameterizedTest
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldBuildDentalOrganizationForPractitioner(KbvItaForVersion kbvItaForVersion) {
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvItaForVersion).withQualificationType(QualificationType.DENTIST).fake();
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.forPractitioner((KbvPractitioner)practitioner).withVersion(kbvItaForVersion).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
        if (kbvItaForVersion == KbvItaForVersion.V1_0_3) {
            Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.KZBV_KZVA_ABRECHNUNGSNUMMER.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
        } else {
            Assertions.assertTrue((boolean)DeBasisProfilNamingSystem.KZBV_KZVA_ABRECHNUNGSNUMMER_SID.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"de.gematik.test.erezept.fhir.testutil.VersionArgumentProvider#kbvItaForVersions"})
    void shouldBuildOrganizationForPractitioner(KbvItaForVersion kbvItaForVersion) {
        KbvPractitioner practitioner = KbvPractitionerFaker.builder().withVersion(kbvItaForVersion).withQualificationType(QualificationType.DOCTOR).fake();
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.forPractitioner((KbvPractitioner)practitioner).withVersion(kbvItaForVersion).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
        Assertions.assertFalse((boolean)DeBasisProfilNamingSystem.KZBV_KZVA_ABRECHNUNGSNUMMER.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
        Assertions.assertFalse((boolean)DeBasisProfilNamingSystem.KZBV_KZVA_ABRECHNUNGSNUMMER_SID.matches(new Identifier[]{organization.getIdentifierFirstRep()}));
    }

    @Test
    void builderFakerMedicalOrganizationWithPhone() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder().withPhoneNumber(GemFaker.fakerPhone()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void builderFakerMedicalOrganizationWithEmail() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder().withEmail(GemFaker.fakerEMail()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void builderFakerMedicalOrganizationWithAddress() {
        KbvMedicalOrganization organization = KbvMedicalOrganizationFaker.builder().withAddress(GemFaker.fakerCity(), GemFaker.fakerZipCode(), GemFaker.fakerStreetName()).fake();
        ValidationResult result = ValidatorUtil.encodeAndValidate(parser, (Resource)organization);
        Assertions.assertTrue((boolean)result.isSuccessful());
    }
}

